import { merge } from "lodash-es";

export const defaultTheme = {
  transMinWidth: 400,
  transHorizontalPadding: 32,
  transVerticalPadding: 16,
  transPaddingBottom: 28,
  paragraphHorizontalPadding: 24,
  paragraphVerticalPadding: 16,
  paragraphMarginTop: 0,
  paragraphMarginBottom: 20,
  unfixBackground: "rgb(242, 245, 251)",
  editorFontFamily:
    "tahoma, 'Microsoft YaHei', 'PingFang SC', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, 'Noto Sans', sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol', 'Noto Color Emoji'",
  unfixParagraphContentSticky: true,
};

export type Theme = typeof defaultTheme;

export const generateTheme = (theme?: Partial<Theme>) => {
  if (!theme) {
    return defaultTheme;
  }
  return merge({}, defaultTheme, theme);
};
