import { Word } from "@tingwujs/core";
import { generateViewedWords } from "../viewedWord";

describe("generateViewedWords-3", () => {
  it("generateViewedWords-3", () => {
    const origin: Word[] = [
      {
        wid: "10",
        beginTime: 13750,
        endTime: 14125,
        text: "介绍介绍谢谢",
        sentenceId: "1",
        tag: "blue",
      },
      {
        wid: "20",
        beginTime: 14125,
        endTime: 14500,
        text: "于老",
        sentenceId: "1",
        tag: "",
      },
      {
        wid: "30",
        beginTime: 14500,
        endTime: 14875,
        text: "师介",
        sentenceId: "1",
        tag: "",
      },
    ];
    const viewedWords = generateViewedWords(origin, [
      {
        startOffset: 2,
        endOffset: 4,
        pid: "1655449957927500000",
      },
    ]);
    const target = [
      {
        beginTime: 13750,
        endTime: 14125,
        tag: "blue",
        text: "介绍介绍谢谢",
        sentenceId: "1",
        wid: "10",
        searchedOffsets: [
          {
            startOffset: 2,
            endOffset: 4,
          },
        ],
      },
      {
        beginTime: 14125,
        endTime: 14500,
        tag: "",
        text: "于老",
        sentenceId: "1",
        wid: "20",
        searchedOffsets: [],
      },
      {
        beginTime: 14500,
        endTime: 14875,
        tag: "",
        text: "师介",
        sentenceId: "1",
        wid: "30",
        searchedOffsets: [],
      },
    ];

    expect(viewedWords).toMatchObject(target);
  });
});
