import { generateViewedWords, ViewedWord } from "../viewedWord";
import { demoCheckpoint, Controller } from "@tingwujs/core";

describe("generateViewedWords-1", () => {
  const controller = new Controller();
  controller.setModelValue(demoCheckpoint);
  const firstPid = controller.getPids()[0];
  const words = controller.getWords(firstPid);

  it("generateViewedWords-1", () => {
    const viewedWords = generateViewedWords(words.slice(0, 5), [
      {
        startOffset: 1,
        endOffset: 5,
        pid: "1655449957927500000",
      },
    ]);

    const target: ViewedWord[] = [
      {
        beginTime: 13750,
        endTime: 14125,
        tag: "blue",
        text: "谢谢",
        sentenceId: "1",
        wid: "10",
        searchedOffsets: [
          {
            startOffset: 1,
            endOffset: 2,
          },
        ],
      },
      {
        beginTime: 14125,
        endTime: 14500,
        tag: "",
        text: "于老",
        sentenceId: "1",
        wid: "20",
        searchedOffsets: [
          {
            startOffset: 0,
            endOffset: 2,
          },
        ],
      },
      {
        beginTime: 14500,
        endTime: 14875,
        tag: "",
        text: "师介",
        sentenceId: "1",
        wid: "30",
        searchedOffsets: [
          {
            startOffset: 0,
            endOffset: 1,
          },
        ],
      },
      {
        beginTime: 14875,
        endTime: 15250,
        tag: "",
        text: "绍，",
        sentenceId: "1",
        wid: "40",
        searchedOffsets: [],
      },
      {
        beginTime: 15251,
        endTime: 15640,
        tag: "",
        text: "这一",
        sentenceId: "1",
        wid: "50",
        searchedOffsets: [],
      },
    ];

    expect(viewedWords).toMatchObject(target);
  });
});
