import { Controller, PID } from "@tingwujs/core";
import React, { memo, useCallback } from "react";
import { generateTranscriptionController } from "../../../controller";
import { TagControlBar } from "../../../components/tagControlBar";
import { isPartialShareFeature } from "../../../utils";

interface MarkHeadingExtraProps {
  controller: Controller;
  pid?: PID;
  emptyUnfix?: boolean;
  visible?: boolean;
  shareDisabled?: boolean;
}

export const MarkHeadingExtra: React.FC<MarkHeadingExtraProps> = memo(props => {
  const { controller, pid, emptyUnfix, visible = true, shareDisabled } = props;
  const tranController = generateTranscriptionController(controller);
  const getHooks = () => {
    return tranController.getHooks();
  };

  const setParagraphColor = useCallback(
    (color: string) => {
      if (pid) {
        controller.setParagraphMark(pid, color);
      } else if (emptyUnfix) {
        controller.setEmptyUnfixTempParagraphMark(color);
      }
    },
    [controller, pid, emptyUnfix]
  );

  const handleClickNail = useCallback(() => {
    const { onEvent } = getHooks();
    onEvent &&
      onEvent("toggleMarkParagraph", {
        isMark: true,
        markColor: "blue",
        isParagraphMark: true,
      });
    setParagraphColor("blue");
  }, [setParagraphColor]);

  const handleClickQuestion = useCallback(() => {
    const { onEvent } = getHooks();
    onEvent &&
      onEvent("toggleMarkParagraph", {
        isMark: true,
        markColor: "red",
        isParagraphMark: true,
      });
    setParagraphColor("red");
  }, [setParagraphColor]);

  const handleClickTodo = useCallback(() => {
    const { onEvent } = getHooks();
    onEvent &&
      onEvent("toggleMarkParagraph", {
        isMark: true,
        markColor: "yellow",
        isParagraphMark: true,
      });
    setParagraphColor("yellow");
  }, [setParagraphColor]);

  const handleClickReset = useCallback(() => {
    const { onEvent } = getHooks();
    onEvent &&
      onEvent("toggleMarkParagraph", {
        isMark: false,
        markColor: "",
        isParagraphMark: true,
      });
    setParagraphColor("");
  }, [setParagraphColor]);

  const handleClickShare = useCallback(() => {
    const { onEvent } = getHooks();
    controller.shareParagraphContents(pid!);
    onEvent && onEvent("shareContents", {});
  }, [controller, pid]);

  if (!visible) {
    return null;
  }

  return (
    <TagControlBar
      title=""
      onClickNail={handleClickNail}
      onClickQuestion={handleClickQuestion}
      onClickTodo={handleClickTodo}
      onClickReset={handleClickReset}
      onClickShare={handleClickShare}
      useHover
      pid={pid}
      isShareFeature={isPartialShareFeature}
      shareDisabled={shareDisabled}
    />
  );
});
