import styled from "styled-components";

export const Wrapper = styled.div`
  &:after {
    content: " ";
    display: block;
    height: 8px;
    background-color: #f2f5fb;
  }
`;

export const Background = styled.div`
  width: 100%;
  height: 60px;
  background-image: linear-gradient(180deg, rgba(249, 250, 255, 0.1) 0%, #f9faff 100%);
  display: flex;
  flex-direction: column;
  justify-content: flex-end;
  align-items: flex-end;
`;

export const ReturnButton = styled.div`
  background: #fff;
  box-shadow: 0 2px 6px 0 rgba(90, 68, 151, 0.14);
  border-radius: 32px;
  width: 32px;
  height: 32px;
  cursor: pointer;
  transition: all 0.2s;
  display: flex;
  justify-content: center;
  align-items: center;

  svg {
    color: #605ce5;
    transition: all 0.2s;
  }
  &:hover {
    background: #605ce5;
    svg {
      color: #fff;
    }
  }
`;
