import { Controller, PID } from "@tingwujs/core";
import React, { memo, useCallback } from "react";
import { TagControlBar } from "../../../components/tagControlBar";

interface ChromeHeadingExtraProps {
  controller: Controller;
  pid?: PID;
  emptyUnfix?: boolean;
  visible?: boolean;
}

export const ChromeHeadingExtra: React.FC<ChromeHeadingExtraProps> = memo(props => {
  const { controller, pid, emptyUnfix, visible = true } = props;

  const setParagraphColor = useCallback(
    (color: string) => {
      if (pid) {
        controller.setParagraphMark(pid, color);
      } else if (emptyUnfix) {
        controller.setEmptyUnfixTempParagraphMark(color);
      }
    },
    [controller, pid, emptyUnfix]
  );

  const handleClickNail = useCallback(() => {
    setParagraphColor("blue");
  }, [setParagraphColor]);

  const handleClickQuestion = useCallback(() => {
    setParagraphColor("red");
  }, [setParagraphColor]);

  const handleClickTodo = useCallback(() => {
    setParagraphColor("yellow");
  }, [setParagraphColor]);

  const handleClickReset = useCallback(() => {
    setParagraphColor("");
  }, [setParagraphColor]);

  if (!visible) {
    return null;
  }

  return (
    <TagControlBar
      title="标记："
      onClickNail={handleClickNail}
      onClickQuestion={handleClickQuestion}
      onClickTodo={handleClickTodo}
      onClickReset={handleClickReset}
      useHover
      pid={pid}
    />
  );
});
