import styled from "styled-components";
import { config } from "../../config";

const { textEditor } = config.theme;

export const WordsStyled = styled.div<{
  isHighlight?: boolean;
}>`
  .qna {
    background-color: var(--Line_Primary);
    color: ${textEditor.color};
  }
  .word-blue {
    background-color: var(--Caution_Disabled);
    color: ${textEditor.color};
  }

  .word-yellow {
    background-color: var(--Processing_Disabled);
    color: ${textEditor.color};
  }

  .word-red {
    background-color: var(--Warning_Disabled);
    color: ${textEditor.color};
  }

  .searched {
    background-color: var(--Text_Disabled);
    color: var(--Text_Brand_Primary);
  }

  .actived {
    background-color: var(--Text_Disabled);
    color: var(--Text_Brand_Primary);
  }

  .strong {
    font-weight: bold;
  }

  .played {
    color: ${props => (props.isHighlight ? "var(--Text_Brand_Primary)" : "var(--Text_Caption)")};
  }

  .word-blue,
  .word-yellow,
  .word-red,
  .qna {
    &.played {
      color: var(--Text_Caption);
    }
  }
`;
