import styled, { css } from "styled-components";
import { WordsStyled } from "../wordsStyled";
import { config } from "../../config";
import { AssistantActiveType } from "@tingwujs/sphere";

const { paragraph } = config.theme;
// 录音中的翻译样式
export const ParagraphTranslate = styled(WordsStyled)<{
  showOrigin?: boolean;
  isHighlight?: boolean;
  isUnfix?: boolean;
  aiReviewActive?: AssistantActiveType | null;
}>`
  width: 100%;
  position: relative;
  font-size: 14px;
  font-family: ${props => props.theme.editorFontFamily};
  line-height: 24px;
  padding: ${props => props.theme.paragraphVerticalPadding}px
    ${props => props.theme.paragraphHorizontalPadding}px;
  background-color: ${paragraph.backgroundColor};
  color: ${props => (props.isHighlight ? "var(--Text_Primary)" : "var(--Text_Secondary)")};
  border-bottom-left-radius: 8px;
  border-bottom-right-radius: 8px;
  caret-color: transparent;
  outline: none;
  cursor: text;
  user-select: text;
  border-top: 1px dashed var(--Line_Secondary);

  ${props => {
    if (!props?.showOrigin && props.aiReviewActive === AssistantActiveType.originActive) {
      return `background-color: #f00;
      `;
    }
    return "";
  }}

  span::selection {
    background-color: var(--Fill_Secondary);
    opacity: 0.6;
    color: ${props => (props.isHighlight ? "var(--Text_Brand_Primary)" : "var(--Text_Caption)")};
  }

  ${props =>
    props.isUnfix &&
    css`
      min-height: 96px;
      user-select: none;
      cursor: default;
    `}

  ${props =>
    props.showOrigin &&
    css`
      padding-top: 8px;
    `}

  ${props =>
    !props.showOrigin &&
    css`
      border-top-left-radius: 8px;
      border-top-right-radius: 8px;
    `}

  ${props =>
    props.isHighlight &&
    css`
      background-color: var(--Fill_Brand_Background);
      /* color: rgba(255, 255, 255, 0.6); */
      color: var(--Text_Primary);
    `}

  &:before {
    content: " ";
    display: ${props => (props.showOrigin && !props.isHighlight ? "block" : "none")};
    background-color: var(--Fill_Transparent_Light);
    height: 1px;
    position: absolute;
    top: 0;
    left: ${props => props.theme.paragraphHorizontalPadding}px;
    right: ${props => props.theme.paragraphHorizontalPadding}px;
  }
`;

// 识别完成
export const FixText = styled.span<{
  isHighlight?: boolean;
  isUnfix?: boolean;
}>`
  ${props =>
    props.isHighlight &&
    `
    .base{
      color: var(--Text_Caption);
    }
    ${
      props.isUnfix &&
      css`
        color: var(--Text_Caption);
      `
    }
    .played{
     color: var(--Text_Primary); 
    }
  `}
`;
// 识别中
export const UnfixText = styled.span`
  color: var(--Text_Caption);
`;
