import { isFirefox } from "@tingwujs/common";

// 避免firefox中，使用输入法编辑时，compositionEnd事件之后还会触发input事件，导致文字插入两次
export class FirefoxCache {
  content: string | undefined;

  time: number | undefined;

  setContent(content: string) {
    this.content = content;
    this.time = Date.now();
  }

  isCompositeBefore(content: string) {
    if (!isFirefox() || !this.content || !this.time) {
      return false;
    }

    if (content === this.content && Math.abs(Date.now() - this.time) < 100) {
      return true;
    }
    return false;
  }
}
