import React from "react";
import { Wrapper, Background, ReturnButton } from "./styled";
import { Tooltip, TYIcon } from "@tingwujs/design";

export const ScrollToBottom: React.FC<{
  onClick?: () => void;
}> = props => {
  const { onClick = () => {}, ...otherProps } = props;
  return (
    <Wrapper {...otherProps}>
      <Background>
        <Tooltip title="回到最新内容" placement="right">
          <ReturnButton data-e2e-test-id="trans_returnNew_button" onClick={onClick}>
            <TYIcon type="tongyi-bottom-line" className="operateItem" />
          </ReturnButton>
        </Tooltip>
      </Background>
    </Wrapper>
  );
};
