import React, { useCallback, useEffect, useRef } from "react";
import { Wrapper, Text, CloseButton } from "./styled";
import { TYIcon } from "@tingwujs/design";

interface LiveSpeakerTipProps {
  onClose?: (isUserAction: boolean) => void;
}

export const LiveSpeakerTip: React.FC<LiveSpeakerTipProps> = ({ onClose }) => {
  const timeoutRef = useRef<ReturnType<typeof setTimeout>>();

  const handleClose = useCallback(() => {
    clearTimeout(timeoutRef.current);
    onClose && onClose(true);
  }, [onClose]);

  useEffect(() => {
    clearTimeout(timeoutRef.current);
    timeoutRef.current = setTimeout(() => {
      onClose && onClose(false);
    }, 6000);
    return () => {
      clearTimeout(timeoutRef.current);
    };
  }, [onClose]);

  return (
    <Wrapper>
      <TYIcon
        type={"icon-warningCircle-line"}
        size={20}
        style={{ color: "var(--Caution_Default)" }}
      />
      <Text>点击发言人可编辑，录音结束可智能区分发言人</Text>
      <CloseButton onClick={handleClose}>
        <TYIcon type={"icon-false-line"} style={{ fontSize: 16, color: "var(--Text_Disabled)" }} />
      </CloseButton>
    </Wrapper>
  );
};
