import styled from "styled-components";
import { miniBackgroundUrl } from "./background";

export const Wrapper = styled.div<{ fullscreen?: boolean }>`
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;

  ${props =>
    props.fullscreen &&
    `
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
  `}
`;

export const Image = styled.div<{
  isMini?: boolean;
}>`
  position: relative;
  background-repeat: no-repeat;

  width: 100px;
  height: 100px;
  background-image: url(${miniBackgroundUrl});
  background-position: center;
  background-size: contain;
`;

export const Text = styled.div`
  font-size: 14px;
  color: var(--Text_Caption);
  line-height: 24px;
  margin-top: 17px;
`;
