import React from "react";
import { Wrapper, Image, Text } from "./styled";

export const Empty: React.FC<{
  fullscreen?: boolean;
  message?: string;
}> = props => {
  const { fullscreen = false, message = "这里空空如也～" } = props;

  return (
    <Wrapper fullscreen={fullscreen}>
      <Image isMini={!fullscreen} />
      <Text>{message}</Text>
    </Wrapper>
  );
};
