import styled, { keyframes } from "styled-components";

const cycleKeyframes = keyframes`
  0% {
    transform: scale(1);
  }

  50% {
    transform: scale(1.66666667);
  }

  100% {
    transform: scale(1);
  }
`;

export const EllipsisStyled = styled.div`
  display: flex;
  align-items: center;
`;

export const EllipsisDot = styled.div<{
  color?: string;
}>`
  animation: ${cycleKeyframes} 1200ms ease-in infinite;
  display: block;
  width: 3px;
  height: 3px;
  border-radius: 3px;
  background-color: ${props => props.color || "rgba(39, 37, 96, .45)"};
  margin-right: 3px;
  &:last-child {
    margin-right: none;
  }
  &:nth-child(1) {
    animation-delay: 0ms;
  }
  &:nth-child(2) {
    animation-delay: 400ms;
  }
  &:nth-child(3) {
    animation-delay: 800ms;
  }
`;
