import React, { memo } from "react";
import { EllipsisStyled, EllipsisDot } from "./styled";

export interface EllipsisProps {
  color?: string;
}

export const Ellipsis: React.FC<EllipsisProps> = memo(props => {
  const { color } = props;
  return (
    <EllipsisStyled>
      <EllipsisDot color={color} />
      <EllipsisDot color={color} />
      <EllipsisDot color={color} />
    </EllipsisStyled>
  );
});
