import React from 'react';
import { AgendaSummaryBean } from '../components/atomicComponent/WuLab/Agenda/types/AgendaBean';

export type ColorType = 'blue' | 'red' | 'yellow';

export interface MarkColorType {
  type: ColorType;
  color: string;
  icon: any;
  id: number;
  iconStyle: React.CSSProperties;
}
/**
 *     type={'icon-problem-line'}
              size={17}
              color={'var(--Warning_Default)'}
 */
const iconStyle = { fontSize: '12px', color: '#fff' };
// 按钮打标色值数据
export const markColors: MarkColorType[] = [
  {
    type: 'blue',
    color: 'var(--Caution_Default)',
    icon: 'icon-extractMark-line',
    iconStyle,
    id: 1,
  },
  {
    type: 'red',
    color: 'var(--Warning_Default)',
    icon: 'icon-help-line',
    iconStyle,
    id: 2,
  },
  {
    type: 'yellow',
    color: 'var(--Processing_Default)',
    icon: 'tongyi-todoList-line',
    iconStyle,
    id: 3,
  },
];
// 音频条/原文区打标色值对照表
export const markColorsMap: any = new Map([
  [
    'var(--Caution_Default)',
    {
      color: 'var(--Caution_Default)',
      tag: '红',
    },
  ],
  [
    'var(--Warning_Default)',
    {
      color: 'var(--Warning_Default)',
      tag: '蓝',
    },
  ],
  [
    'var(--Processing_Default)',
    {
      color: 'var(--Processing_Default)',
      tag: '黄',
    },
  ],
]);

export const ON_WULAB_PICK = 'onWulabPick';
export const ON_WULAB_SORT = 'onWulabSort';
export const VISIBLE_SPREAKER_TINGWU2 = 'visible_speaker_tingwu2';
export const SKIPBLANK_TINGWU2 = 'skipBlak_tingwu2';
export const ON_REVIEW_EMPPHASIS = 'on_review_emphasis';
export const ON_REVIEW_PPT = 'on_review_PPT'; // PPT 回顾
export const ON_PHOTOVIEWER = 'on_PhotoViewer'; // 打开图片查看器
export const ON_PPT_VISIBLE = 'on_PPT_visible'; // 初始化
export const ON_PPT_DOT_VISIBLE = 'on_PPT_dot_visible'; // 初始化
export const ON_SEEKING_CHANGE = 'onSeekingChange';
export const ON_VIDEO_SIZE_TOGGLE = 'onVideoSizeToggle';
export const ON_HIDE_CONTROL_BAR = 'onHideControlBar';
export const ON_SEEKING_CHANGE_SMALL = 'onSeekingChangeSmall';
export const ON_VIDEO_SIZE_TOGGLE_SMALL = 'onVideoSizeToggleSmall';
export const ON_HIDE_CONTROL_BAR_SMALL = 'onHideControlBarSmall';
export const QA_OPEN_ALL = 'QA_open_all'; // QA展开
export const YUWQUEVISIBLE_AUDIO = 'yuqueVisible_audio';
export const CLOSE_BOX_POP = 'close_box_pop';
export const CUR_PAGE_AI_REVIEW = 'CUR_PAGE_AI_REVIEW'; // 当前纪要ai 回溯
export const BIG_MODEL_LOADED = 'big-model-loaded'; // 所有大模型加载完成
export const BIG_MODEL_AGENDA_EDIT_VERIFY = 'big-model-agenda-edit-verify'; // 章节速览内容校验
export const OPEN_FULLSUMMARY_ALLS = 'open_FullSummary_alls'; // 展开全文概要
export const INTERPOSITION_DATA = 'interposition_data'; // 展开全文概要
export const SAVE_SERVER_RIGHT_NOTE = 'save_server_right_note'; // 笔记保存到服务端

export enum agendaVerifyType {
  length = 'length',
  serviceError = 'serviceError',
  valueNull = 'valueNull',
}
export const langs = [
  {
    id: 1,
    value: '中文',
    key: 'cn',
  },
  {
    id: 2,
    value: '英语',
    key: 'en',
  },
  {
    id: 3,
    value: '粤语',
    key: 'yue',
  },
  {
    id: 4,
    value: '中英文自由说',
    key: 'fspk',
  },
  {
    id: 5,
    value: '日语',
    key: 'ja',
  },
];

export enum langValueMap {
  cn = 1,
  en = 2,
  yue = 3,
  fspk = 4,
  ja = 5,
}

export enum langTextMap {
  '不翻译' = 0,
  '中文' = 1,
  '英语' = 2,
  '粤语' = 3,
  '中英文自由说' = 4,
  '日语' = 5,
}

export enum ContentTabType {
  introduction = 1,
  mindmap = 2,
  note = 3,
  prompt = 4,
}
/**
 * File 离线详情
 * Share 分享/盒子收藏
 *       true 盒子收藏/分享
 *       false 离线分享
 * Box 盒子详情页
 */
export enum FileModel {
  File = 'file',
  Share = 'share',
  Box = 'box',
  Live = 'live',
}

export enum FileTools {
  Search = 'search',
  Replace = 'replace',
  Copy = 'copy',
  Filter = 'filter',
  Translate = 'translate',
  Video = 'video',
  Speaker = 'speaker',
  TextPolish = 'textPolish',
}

// 源语言是否支持翻译(中/英/日/中英自由说)
export const isSourceLanguageSupportTranslate = (type: string | number) => {
  if (typeof type === 'number') {
    return [1, 2, 5, 4].includes(type);
  }

  return ['cn', 'en', 'ja', 'fspk'].includes(type);
};

/**
 * 大模型支持编辑
 * keyWordsExtractor 关键词
 * fullSummary 全文概要
 * titleGenerator 章节速览及摘要
 */
export type BigModelUseEditType =
  | 'keyWordsExtractor'
  | 'fullSummary'
  | 'titleGenerator';
export enum BigModelUseEdit {
  KeyWordsExtractor = 'keyWordsExtractor',
  FullSummary = 'fullSummary',
  TitleGenerator = 'titleGenerator',
}

export const dataGo = () => {};

export const getAgendaSummer = (data: {
  agendasSummaryInfoValuse: any[];
  agendas: any[];
  feedbackDetailList?: any[];
}) => {
  const _agendasSummary: AgendaSummaryBean[] =
    data.agendasSummaryInfoValuse.map((item) => {
      let feedbackDetail;
      if (data.feedbackDetailList) {
        feedbackDetail = data.feedbackDetailList.find(
          (i) => i.bindId === item.id,
        );
      }
      const _agenda = data.agendas.find((i) => i.id === item.id);
      const _item: AgendaSummaryBean = {
        id: `${item.id}`,
        agendaHeading: _agenda?.text || '',
        beginTime: (_agenda?.startTime || 0) * 1000,
        endTime: (_agenda?.endTime || 0) * 1000,
        content: item.value,
        star: feedbackDetail ? feedbackDetail.feedbackChoice : undefined,
        tag: feedbackDetail
          ? JSON.parse(feedbackDetail.feedbackInfo)
          : undefined,
      };
      return _item;
    });
  return _agendasSummary;
};

// 智能速览提示信息
export const quickLookHelpTip = {
  fspk: '当前记录音视频语言为中英文自由说，暂未支持待办事项功能，敬请期待',
  yue: '当前记录音视频语言为粤语，仅支持关键词、章节速览和提取PPT，更多功能敬请期待',
  ja: '当前记录音视频语言为日语，仅支持提取PPT，更多功能敬请期待',
};

export const SET_TITLE_SAVE_TEST = 'set_title_save_text'; // 标题下面的保存状态设置
export const BIGMODEL_ITEM_EDIT = 'bigModel_item_edit'; // 大模型正在编辑中
export const OPEN_PTT_ALLS = 'open_PTT_alls'; // 选中并展开PPT
export const SCROLLINTOVIEW_PPT_ITEM = 'scrollIntoView_PTT_item'; // 滚动到选中ppt位置
export const SETAUDIORSSINFO = 'set_audio_rssinfo';
export const ICONBUTTON_POPWINDIW_VISIBLE_TINGWU2 =
  'iconButton_popWindow_visible_tingwu2';

export const SHOWBIGMODEL_ERROR_MESSAGE = 'show_bigModel_error_message';

export enum Tabs {
  Agenda = 'Agenda',
  SpeakerSummary = 'SpeakerSummary',
  PPT = 'PPT',
  Highlights = 'Highlights',
  QNAReview = 'QNAReview',
  ToDoList = 'ToDoList',
}
let numAva = 0;
export const pushNumAva = () => {
  return numAva++;
};

export const setNumAva = (num: number) => {
  numAva = num;
};

export const clearNumAva = () => {
  numAva = 0;
};
export const PPT_INPUT_FOCUS = 'bigModel_PPT_input_focus'; // ppt input 获取焦点

export const oneHour = 3600 * 1000;

// 请求唯一标识
let Filekey = '';
export const setFileKey = (key: string) => {
  Filekey = key;
};

export const getFileKey = () => {
  return Filekey;
};

export const tabsLangs = {
  Agenda: ['cn', 'en', 'yue', 'fspk'],
  SpeakerSummary: ['cn', 'en', 'fspk'],
  PPT: ['cn', 'en', 'ja', 'yue', 'fspk'],
  Highlights: ['cn', 'en', 'fspk'],
  QNAReview: ['cn', 'en', 'fspk'],
  ToDoList: ['cn', 'en'],
  FullSummary: ['cn', 'en', 'fspk'],
  KeyWord: ['cn', 'en', 'yue', 'fspk'],
};
