import styled, { createGlobalStyle, keyframes } from 'styled-components';
import { MAX_INPUT_WIDTH } from '../detailLayout/styled';

export const FileContainerBg = styled.div`
  position: relative;
  height: 100vh;
  min-width: 1280px;
  min-height: 560px;
  background: #f4f7fc;
  overflow: hidden;
  .editorDragon {
    height: 100%;
    padding-bottom: 105px;
    background-color: var(--Fill_Background_Light);
    border-radius: 8px !important;
    padding-left: 30px;
    padding-right: 30px;
    padding-top: 30px;
    position: relative;
  }
`;

export const FileContainer = styled.div`
  display: none;
  margin: 0 auto;
  display: flex;
  height: 100%;
  overflow: hidden;
  .fileEditorViewportClose {
    height: calc(100% - 56px);
    display: flex;
    /* justify-content: center; */
    align-items: center;
    /* margin-left: -28px;
    margin-right: 6px; */
    z-index: 1;
    width: 62px;
  }
  .editorContent {
    -webkit-box-flex: 7;
    flex: 7 0 0px;
    position: relative;
    width: 0px;
  }
  .fileEditorViewport {
    flex: 5;
    width: 0;
    height: calc(100% - 56px);
    margin-right: 28px;
    margin-top: 28px;
    position: relative;
    padding: 0px;
    .yuqueArrow {
      position: absolute;
      left: -10px;
      top: 50%;
      cursor: pointer;
    }
    .editorDragon {
      height: 100%;
      padding-bottom: 105px;
      background-color: var(--Fill_Background_Light);
      border-radius: 8px !important;
      padding-left: 30px;
      padding-right: 30px;
      padding-top: 30px;
      position: relative;
    }
  }
  .rightAreaDragon {
    flex: 1;
    width: 0;
    height: calc(100% - 56px);
    margin-right: 28px;
    margin-top: 28px;
    position: relative;
    padding: 0px;
    background-color: var(--Fill_Background_Light);
    border-radius: 8px;
  }
  .resizable_video {
    box-sizing: border-box;
  }
  .resizable_video_small {
    &::after {
      content: '';
      display: block;
      width: 100%;
      height: 100%;
      border: 1px solid transparent;
      position: absolute;
      top: 0;
      left: 0;
      border-radius: 8px;
      z-index: 600;
      pointer-events: none;
    }
    &:hover {
      box-shadow: 0 4px 11px 0 rgba(72, 76, 82, 0.25);

      &::after {
        border: 1px solid var(--Text_Primary);
        box-shadow: 0 4px 11px 0 rgba(72, 76, 82, 0.25);
        position: absolute;
      }
    }
  }
  .editorContentBottom {
    display: flex;
    /* padding-right: 32px; */
    justify-content: center;
    overflow: hidden;
    .editorContentBottomLeft {
      display: flex;
      flex-direction: column;
      flex-grow: 1.2;
      flex-basis: 0;
      flex-shrink: 0;
      overflow-y: auto;
      overflow-x: hidden;
      position: relative;
      /* padding-left: 32px;
      padding-right: 32px; */
      min-width: 376px;

      .goldplay__screen--poster {
        width: 100% !important;
        height: 100% !important;
      }
    }
  }
  .editorContentBottom :focus-visible {
    outline: none !important; /* 或者使用您希望的边框、阴影等样式 */
  }
  .editorContentBottomLeftContent {
    height: calc(100% - 48px);
    overflow: overlay;
    overflow-x: hidden;
    flex-grow: 1;
    flex-basis: 0;
    flex-shrink: 0;
    .tignwu2_paragraphStyled {
      border-radius: 8px;
      .tingwu2_paragraphTranslate {
        border-bottom-left-radius: 8px;
        border-bottom-right-radius: 8px;
      }
      .tingwu2_paragraphTranslate_showOrigin {
        border-radius: 8px;
      }
    }
  }
  .hideVideo {
    position: absolute;
    z-index: 1111;
    background: rgba(0, 0, 0, 0.4);
    height: 28px;
    width: 28px;
    border-radius: 50%;
    margin-top: 20px;
    right: 16px;
    text-align: center;
    padding-top: 6px;
    transform: rotate(90deg);
    cursor: pointer;
  }
  .hideVideoBig {
    position: absolute;
    z-index: 601;
    background: rgba(0, 0, 0, 0.4);
    height: 28px;
    width: 28px;
    border-radius: 50%;
    margin-top: 20px;
    right: 16px;
    text-align: center;
    padding-top: 6px;
    transform: rotate(90deg);
    cursor: pointer;
  }
  #video > div:nth-child(1),
  #video > div:nth-child(2) {
    border-radius: 9px;
  }
  .keyWord {
    :hover {
      .right {
        display: flex;
        align-items: center;
        cursor: pointer;
      }
    }
  }
  .audioPlayer {
    position: relative;
    .audioPlayer-warn {
      position: absolute;
      color: red;
      font-size: 12px;
      top: 0;
      left: 0;
    }
  }
  .loading {
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  .yuque-close {
    .yuque-close-icon-hover {
      display: none;
    }
    .yuque-close-icon {
      display: block;
    }
    :hover {
      .yuque-close-icon-hover {
        display: block;
        /* transform:rotate(180deg); */
      }
      .yuque-close-icon {
        display: none;
      }
    }
  }
`;

export const Content = styled.div`
  width: 100%;
  display: flex;
  flex-grow: 1;
  background: #f7f8fc;
`;

export const GlobalStyle = createGlobalStyle`
  :fullscreen{
    .tingwu-icon{
      width: 28px;
      height: 28px;
    }
  }
`;

export const EmptyContent = styled.div`
  height: 100%;
  width: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  .emptyText {
    margin-left: 12px;
    font-weight: 400;
    font-size: 20px;
    color: rgba(39, 38, 77, 0.25);
    letter-spacing: 0;
    line-height: 28px;
  }
`;

const showSlowly = keyframes`
  0% {
    opacity: 0;
  }

  100% {
    opacity: 1;
  }
`;

const top2Bottom = keyframes`
  0% {
    transform: translateY(-89px);
  }

  100% {
    transform: translateY(0);
  }
`;

const top2BottomEditor = keyframes`
  0% {
    transform: translateY(-28px);
  }

  55% {
    transform: translateY(4px);
  }

  100% {
    transform: translateY(0);
  }
`;

// 详情页 动画class
export const FileAnimationStyle = createGlobalStyle`
  /* 左侧工具栏 */
  .file-left-tools {
    animation: ${showSlowly} 0.3s;
  }

  /* 顶部工具栏 */
  .file-top-tools {
    animation: ${showSlowly} 0.3s;
  }

  /* 原文区 */
  .editorContentBottom {
    animation: ${showSlowly} 0.3s 50ms, ${top2Bottom} 0.3s 50ms;
  }

  .editorViewport {
    animation: ${showSlowly} 0.3s, ${top2BottomEditor} 0.5s;
  }
`;

export const CloseBtn = styled.div`
  width: 40px;
  height: 40px;
  display: flex;
  align-items: center;
  justify-content: center;
`;

export const TranscriptionFailWrap = styled.div`
  height: 100%;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
`;

export const TranscriptionFailContent = styled.div`
  height: 320px;
  width: 320px;
  background: url(https://img.alicdn.com/imgextra/i3/O1CN01NVnq8i1LxDif3btMk_!!6000000001365-2-tps-640-640.png)
    center no-repeat;
  text-align: center;
  background-size: cover;
  .contentTitle {
    margin-top: 168px;
    font-size: 16px;
    font-weight: 500;
    line-height: 24px;
    text-align: center;
    letter-spacing: normal;
    color: rgba(38, 36, 76, 0.88);
  }

  .contentDesc {
    margin-top: 8px;
    font-size: 12px;
    font-weight: normal;
    line-height: 20px;
    text-align: center;
    letter-spacing: normal;
    color: rgba(38, 36, 76, 0.65);
  }
`;

export const ButtonWrap = styled.div`
  display: flex;
  gap: 8px;
  font-family: PingFang SC;
  font-size: 14px;
  font-weight: 500;
  line-height: 24px;
  letter-spacing: normal;
  /* text/primary */
  /* 样式描述：blue 600 */
  color: #1366ec;
  justify-content: center;
  align-items: center;
  box-sizing: border-box;
  /* border/disabled */
  /* 样式描述：gray 300 */
  border: 1px solid #d8d8d8;
  padding: 4px 8px 4px 12px;
  border-radius: 0;
  cursor: pointer;
`;
