import styled from 'styled-components';
export const MIN_CONTENT_WIDTH = 560;
export const MAX_INPUT_WIDTH = 300;

export const MAX_WIDTH = '100%';

export const Page = styled.div<{
  minWidth?: number;
}>`
  display: flex;
  flex-direction: column;
  width: 100%;
  height: 100%;
  min-width: ${(props) => props.minWidth || MIN_CONTENT_WIDTH * 2}px;
  margin: 0 auto;
  font-family: 'PingFang SC';
  box-sizing: border-box;
  overflow-x: auto;
  overflow-y: hidden;
`;

export const PageHeader = styled.div`
  height: 64px;
  /* border-bottom: 1px solid var(--Line_Secondary); */
  background-color: #fbfbfd;
  padding: 14px 20px 14px 20px;
`;

export const PageHeaderInner = styled.div<{
  maxWidth?: number | string;
}>`
  height: 100%;
  width: 100%;
  max-width: ${(props) => props.maxWidth || MAX_WIDTH}px;
  margin: 0 auto;
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

export const PageContent = styled.div`
  flex: 1;
  flex-shrink: 0;
  display: flex;
  background-color: var(--Fill_Background);
  overflow: hidden;
`;

export const PageContentInner = styled.div<{
  maxWidth?: number | string;
}>`
  height: 100%;
  width: 100%;
  max-width: ${(props) => props.maxWidth || MAX_WIDTH}px;
  margin: 0 auto;
  display: block;
  overflow: auto;
`;

export const PageDetailContainer = styled.div`
  width: 100%;
  height: calc(100vh - 64px);
  overflow: hidden;
  display: flex;
`;

export const LeftContent = styled.div<{ leftMinWidth?: number }>`
  min-width: ${(props) =>
    props.leftMinWidth ? props.leftMinWidth : MIN_CONTENT_WIDTH}px;
  height: 100%;
  flex: 1 1;
  position: relative;
  background-color: var(--Fill_Background_Light);
  overflow: hidden;
  .navTop {
    display: flex;
    align-items: center;
    justify-content: space-between;
    height: 52px;
    padding: 0 32px;
    .navTopLf {
      display: flex;
      align-items: center;

      &__Icon {
        margin-right: 1px;
        font-size: 20px;
        flex-shrink: 0;
        color: var(--Text_Primary);
      }
    }
  }
`;

export const RightContent = styled.div`
  min-width: ${MIN_CONTENT_WIDTH}px;
  height: 100%;
  position: relative;
  background-color: var(--Fill_Background_Light);
  overflow: hidden;
`;

export const MidLine = styled.div`
  height: 100%;
  width: 1px;
  background-color: var(--Line_Secondary);
`;

export const Title = styled.div`
  color: var(--Text_Primary);
  padding: 0 4px;
  font-size: 18px;
  font-weight: 500;
  line-height: 24px;
  max-width: ${MAX_INPUT_WIDTH}px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;

export const LeftTitle = styled.div`
  font-family: PingFang SC;
  font-size: 16px;
  font-weight: 500;
  line-height: 24px;
  letter-spacing: normal;
  color: var(--Text_Primary);
`;
