import { useEffect } from 'react';

import { Controller } from '@tingwujs/core';
import {
  AgendaSummaryController,
  AiAssistantController,
  MeetingSummaryController,
  PresentationSummaryController,
  QnAController,
  // SpeakerSummaryController,
  SphereContext,
} from '@tingwujs/sphere';
import {
  destroyCommonData,
  destroyEditorData,
  destroyParagraphsData,
  destroyPlayerData,
  destroySpeakerRolesData,
  destroyTransRefData,
} from '../constVariable';

let controller: any;
let context: any;
let qnaController: any;
let aiAssistantController: any;
let agendaSummaryController: any;
let meetingSummaryController: any;
// let speakerSummaryController: any;
let presentationSummaryController: any;

export const useDataHooks = (flag?: boolean) => {
  useEffect(() => {
    if (controller || !flag) return;
    controller = new Controller();
    context = new SphereContext(controller as any);
    qnaController = new QnAController(context);
    aiAssistantController = new AiAssistantController(context);
    agendaSummaryController = new AgendaSummaryController(context);
    meetingSummaryController = new MeetingSummaryController(context);
    // speakerSummaryController = new SpeakerSummaryController(context);
    presentationSummaryController = new PresentationSummaryController(context);

    return () => {
      controller = null;
      context = null;
      qnaController = null;
      agendaSummaryController = null;
      meetingSummaryController = null;
      presentationSummaryController = null;
      destroyCommonData();
      destroyEditorData();
      destroyParagraphsData();
      destroyTransRefData();
      destroyPlayerData();
      destroySpeakerRolesData();
    };
  }, [flag]);

  return {
    controller,
    context,
    qnaController,
    aiAssistantController,
    agendaSummaryController,
    meetingSummaryController,
    // speakerSummaryController,
    presentationSummaryController,
  };
};
