import React from 'react';
import { CardHeaderContainer } from './styled';

interface CardHeaderProps {
  titleIconType?: 'line' | 'Other' | '';
  titleIcon?: React.ReactNode;
  style?: React.CSSProperties;
  titleText?: string;
}

const CardHeader = ({ titleText, style, titleIcon }: CardHeaderProps) => {
  return (
    <CardHeaderContainer style={{ ...style }}>
      <div className="title">
        {titleIcon}
        {/* win下加粗不明显区分下 */}
        {titleText && <span className="text-wrap">{titleText}</span>}
      </div>
    </CardHeaderContainer>
  );
};

export default CardHeader;
