import { Popover } from '@tingwujs/design';
import { Radio } from 'antd';
import styled from 'styled-components';

export const ToolsWrapper = styled.div`
  display: flex;
  position: absolute;
  right: 33px;
  height: 48px;
  top: 0;
  align-items: center;

  .tools-btn {
    margin-right: 10px;
    border-radius: 50%;
    /* background: var(--Fill_Background_Light) !important; */
    /* border: 1px solid var(--Line_Light) !important; */
  }
`;

export const CustomPopover = styled(Popover)`
  .ant-popover-inner {
    padding: 12px !important;
    border-radius: 20px !important;
  }
`;

export const RadioButtonGroup = styled(Radio.Group)`
  .ant-radio-button-wrapper {
    border: none !important;
  }

  .ant-radio-button-wrapper-checked:not(
      .ant-radio-button-wrapper-disabled
    )::before {
    background-color: transparent !important;
  }
  .ant-radio-button-wrapper:not(:first-child)::before {
    background-color: transparent !important;
  }

  .ant-radio-button-wrapper-checked:not(.ant-radio-button-wrapper-disabled) {
    color: var(--Fill_Brand_Primary);
    background-color: var(--Fill_Brand_Background);
    border-radius: 4px;
  }
`;
