export const computeHeight = (nodes: NodeList, maxShowCount = 1) => {
  let firstItemHeight = 0;
  let sumHeight = 0;
  let firstShort = false;

  Array.prototype.forEach.call(nodes, (node: HTMLDivElement, index) => {
    const { height } = node.getBoundingClientRect();
    if (
      Array(maxShowCount + 1)
        .fill(1)
        .map((_, i) => i)
        .includes(index)
    )
      firstItemHeight += height;
    sumHeight += height + 8;

    if (index === nodes.length - 1) {
      sumHeight -= 8;
    }
  });

  if (nodes.length !== 1) {
    if (firstItemHeight < 158) {
      firstItemHeight = 158;
    }
  }

  if (nodes.length === 1) {
    if (firstItemHeight > 164) {
      firstItemHeight = 154;
    } else {
      firstShort = true;
    }
  }
  return {
    firstItemHeight,
    sumHeight,
    firstShort,
  };
};
