import React, { memo, useEffect, useMemo, useRef, useState } from 'react';

// *** 二方包相关 ***
import { SummaryErrorText } from '@tingwujs/sphere';
// *** 工具相关 ***
import { computeHeight } from './utils/computeHeight.util';
// *** 公共组件 ***
import DefaultAvatarComp from '../../../../../../components/BaseCompontents/AvatarComp';
import AvatarComp from '../../../../../../components/BaseCompontents/AvatarCompForRandom';
// *** 公共业务组件
import { SpeakerSummaryItem } from './speakerSummaryItem';
// *** 业务Hook相关 ***
import { useSpeakSummaryDataProcess } from './hooks';
// *** 样式文件 ***
import { SpeakerSummaryListContainer } from './styled';
// *** 类型文件 ***
import { SpeakerSummaryListProps } from './speakerSummaryList.type';

export const SpeakerSummaryList: React.FC<SpeakerSummaryListProps> = memo(
  (props) => {
    const {
      short = false,
      style,
      className,
      isFail,
      errorText,
      maxShowCount = 1,
      isSpeakerSummaryExpand,
    } = props;

    const { speakSummaryList } = useSpeakSummaryDataProcess();
    const containerRef = useRef<HTMLDivElement>(null);
    const [warpHeight, setWarpHeight] = useState(0);

    const [firstItemHeight, setFirstItemHeight] = useState(0);

    useEffect(() => {
      if (!containerRef.current) return;

      const observer = new ResizeObserver(() => {
        if (containerRef.current) {
          const { height } = containerRef.current.getBoundingClientRect();
          if (height > 0) {
            containerRef.current.style.transition = 'height 0.3s';
          }

          const {
            sumHeight,
            firstItemHeight: _firstItemHeight,
            firstShort,
          } = computeHeight(containerRef.current.childNodes);

          setWarpHeight(sumHeight);
          setFirstItemHeight(_firstItemHeight);
          const isBigModelButtonDom: any = document.getElementById(
            'isBigModel_alls_button',
          );
          if (isBigModelButtonDom) {
            if (firstShort) {
              isBigModelButtonDom.style.display = 'none';
            } else {
              isBigModelButtonDom.style.display = 'flex';
            }
          }
        }
      });
      observer.observe(containerRef.current);

      return () => {
        observer.disconnect();
      };
    }, [speakSummaryList]);

    const contentClassRef = useRef('opacity');

    const renderedContent = useMemo(() => {
      if (errorText) {
        return <SummaryErrorText text={errorText} />;
      }

      if (isFail) {
        return <SummaryErrorText isFail />;
      }

      if (speakSummaryList.length === 0) {
        return <SummaryErrorText isEmpty />;
      }

      const height = !isSpeakerSummaryExpand ? firstItemHeight : warpHeight;

      return (
        <SpeakerSummaryListContainer
          ref={containerRef}
          style={
            warpHeight
              ? {
                  height,
                  paddingBottom: 2,
                  boxSizing: 'content-box',
                }
              : { paddingBottom: 2 }
          }
        >
          {speakSummaryList.map((summary, index) => (
            <SpeakerSummaryItem
              key={summary.id}
              summary={summary}
              expanded={!short}
              isExpandItem={index === maxShowCount && short}
              contentClassRef={contentClassRef}
              index={index}
            />
          ))}
        </SpeakerSummaryListContainer>
      );
    }, [
      errorText,
      isFail,
      speakSummaryList,
      isSpeakerSummaryExpand,
      firstItemHeight,
      warpHeight,
      short,
      maxShowCount,
    ]);

    return (
      <div style={style} className={className}>
        {renderedContent}
      </div>
    );
  },
);

export const renderCommonUseAvatar = (speaker: any) => {
  if (typeof speaker.nameAvaId !== 'undefined') {
    return (
      <AvatarComp
        avaTextOrign={speaker.name}
        avatarUrl={speaker.avatarUrl}
        sizeStyle={24}
        nameSizeStyle={14}
        nameId={speaker.nameAvaId}
      />
    );
  } else {
    return (
      <DefaultAvatarComp avaTextOrign={speaker.name} sizeStyle={24} realName />
    );
  }
};
