import { docSpeakerHooks } from '../../../../../../../documentModel';
import { getDefaultName } from '../../../../../../../utils/speakerUtils';
import { useMemo } from 'react';
import { useSpeakSummaryDataProcess } from './useSpeakSummaryDataProcess.hook';

/**
 * @description: 获取发言总结文本内容
 */
const useSpeakerSummaryText = () => {
  const { speakSummaryList } = useSpeakSummaryDataProcess();
  const { getSpeakerDataFromUid } = docSpeakerHooks.useDocSpeakerData();

  const speakerSummaryText = useMemo(() => {
    const list = speakSummaryList
      .filter(({ content }) => !!content)
      .map((summary: any) => {
        const speaker = getSpeakerDataFromUid(summary.uid);
        const name = speaker
          ? speaker.name || getDefaultName(speaker?.ui, true)
          : '未知发言人';

        return [name, summary.content].join('\n');
      })
      .join('\n');
    return list;
  }, [getSpeakerDataFromUid, speakSummaryList]);

  return {
    speakerSummaryText,
  };
};

export { useSpeakerSummaryText };
