import { useMemo } from 'react';
// *** 三方包相关 ***
import { produce } from 'immer';
// *** Model 层数据引用相关 ***
import {
  docBigModelHooks,
  docTranslateHooks,
} from '../../../../../../../documentModel';
import { eLabInfoStatus } from '../../../../../../../documentModel/docBigModel';

const useSpeakSummaryDataProcess = () => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const { docTranslateData } = docTranslateHooks.useDocTranslateData();
  const { translateIsOpen, bigModelTranslate } = docTranslateData || {};

  const originSpeakSummaryList = useMemo(
    () =>
      (currentDocBigModelData?.speakSummary || []).map((item) => ({
        id: item.id,
        uid: String(item.speaker),
        content: item.value || '发言内容太少了，无总结内容哦',
        isTextTooShort:
          currentDocBigModelData?.speakSummaryStatus ===
          eLabInfoStatus.TEXT_TOO_SHORT,
        isContentNone: !item.value,
      })),
    [
      currentDocBigModelData?.speakSummary,
      currentDocBigModelData?.speakSummaryStatus,
    ],
  );

  const translateSpeakSummaryList = useMemo(() => {
    return produce(originSpeakSummaryList, (draft) => {
      draft.forEach((item) => {
        const transValue = bigModelTranslate?.roleSummary?.find(
          (roleSummary) => roleSummary.id === item.id,
        )?.value;
        if (
          transValue &&
          String(transValue).trim() &&
          String(transValue).trim()?.length
        ) {
          item.content = transValue;
        }
      });
    });
  }, [bigModelTranslate?.roleSummary, originSpeakSummaryList]);

  return useMemo(
    () => ({
      speakSummaryList: translateIsOpen
        ? translateSpeakSummaryList
        : originSpeakSummaryList,
    }),
    [originSpeakSummaryList, translateIsOpen, translateSpeakSummaryList],
  );
};

export { useSpeakSummaryDataProcess };
