import { documentHooks } from '../../../../../../documentModel';

const useMeetingSummary = ({
  dirtyMeetingSummaryCardToYQRef,
  setEditFullSummary,
}) => {
  const {
    documentData: { docId: transId },
  } = documentHooks.useDocumentData();

  const meetingSummaryCancel = () => {
    dirtyMeetingSummaryCardToYQRef.current?.onCancel();
  };

  const meetingSummaryConfirm = () => {
    dirtyMeetingSummaryCardToYQRef.current?.onConfirm();
  };

  const onEditFullSummary = (edit: boolean) => {
    setEditFullSummary(edit);
  };
  return {
    meetingSummaryCancel,
    meetingSummaryConfirm,
    onEditFullSummary,
  };
};

export default useMeetingSummary;
