import styled from 'styled-components';

const EmptyContainer = styled.div`
  user-select: none;
  font-size: 14px;
  font-weight: 400;
  color: var(--Text_Disabled);
  .empty-button {
    color: var(--Text_Primary);
    cursor: pointer;
  }
`;

const Empty = ({
  text,
  onAdd,
  styles,
}: {
  text: string;
  onAdd?: () => void;
  styles?: any;
}) => {
  return (
    <EmptyContainer style={{ ...styles }}>
      <span>{text}</span>
      {onAdd ? <span>，</span> : null}
      {onAdd ? (
        <span className="empty-button" onClick={onAdd}>
          立即添加
        </span>
      ) : null}
    </EmptyContainer>
  );
};
export default Empty;
