import { eTheme } from '../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import styled from 'styled-components';
import { SummaryExtractionStyled } from '../common/SummaryExtraction';

export const ToDoListContainer = styled.div<{ theme: eTheme }>`
  overflow: hidden;
  transition: height 0.3s;
  ${({ theme }) =>
    theme === eTheme.SUMMARY_ITEM ? ' padding: 0px 16px 10px 16px' : ''};
`;

interface ToDoListItemProps {
  theme: eTheme;
  focus: boolean;
}

export const ToDoListItem = styled(SummaryExtractionStyled)<ToDoListItemProps>`
  display: flex;
  align-items: center;
  min-height: 40px;
  padding: 8px 0;
  border-radius: 4px;
  position: relative;
  cursor: ${({ theme }) =>
    theme === eTheme.SUMMARY_ITEM ? 'pointer' : 'default'};

  .toDoListItemShare {
    position: absolute;
    top: 13px;
    right: 16px;
    display: none;
    cursor: pointer;
  }

  &:hover {
    /* background-color: #e7e7fb; */
    /* border: 1px solid var(--TY-Link-1); */
    .GistItem__Review {
      display: ${({ theme }) =>
        theme === eTheme.SUMMARY_ITEM ? 'none' : 'block'};
    }
  }
  .GistItem__Review {
    align-items: center;
    height: 24px;
    gap: 4px;
    font-weight: 400;
    font-size: 12px;
    color: #615ced;
    line-height: 24px;
    cursor: pointer;
    display: none;
    white-space: nowrap;
    position: absolute;
    right: 20px;
    /* padding-left: 4px; */
    /* background-color: #e7e7fb; */
    svg {
      width: 14px;
    }
  }
`;

export const IconContainer = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 0px 8px 0 15px;
`;

export const ToDoListItemContent = styled.div`
  font-size: 14px;
  color: var(--Text_Primary);
  cursor: default;
  /* text-overflow: ellipsis;
  overflow: hidden;
  white-space: nowrap; */
  /* height: 22px; */
  line-height: 22px;
`;

export const ToDoListItemValue = styled.span`
  overflow-wrap: anywhere;
  position: relative;
  color: var(--Text_Primary);
  cursor: pointer;
  display: -webkit-box;
  overflow: hidden;
  text-overflow: ellipsis;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  max-width: 100%;
`;

export const ToDoTodoInputContent = styled(SummaryExtractionStyled)`
  position: relative;
  cursor: pointer;
  width: 100%;
  min-height: 40px;
  padding: 2px;
  margin-bottom: 4px;

  .toDoTodoInputContentIcon {
    margin-right: 8px;
  }

  .toDoTodoInput {
    flex: 1;
  }
  [contenteditable]:focus {
    outline: none;
    font-weight: normal;
  }
  .AdendaTimeItemInput-tips {
    position: absolute;
    top: -52px;
    left: 0px;
    height: 52px;
    width: 128px;
    background-color: var(--Fill_Background_Light);
    box-shadow:
      0 3px 6px -4px rgba(39, 38, 77, 0.12),
      0 6px 16px 0 rgba(39, 38, 77, 0.08),
      0 9px 28px 8px rgba(39, 38, 77, 0.05);
    border-radius: 8px;
    align-items: center;
    cursor: pointer;
    font-weight: 400;
    font-size: 14px;
    color: var(--Text_Primary);
    padding: 6px 0px;
    display: none;
    z-index: 3;
  }
  :hover {
    .AdendaTimeItemInput-tips-hover {
      display: flex;
    }
  }
  .AdendaTimeItemInput-value-out-icon {
    display: flex;
  }
  .AdendaTimeItemInput-value-out {
    display: flex;
    align-items: center;
    flex-direction: row;
    min-height: 40px;
    width: 100%;
    /* background-color: var(--Fill_Background_Light);
    border-radius: 4px;
    padding-left: 14px;
    padding-top: 8px;
    padding-bottom: 8px;
    padding-right: 16px;
    border: ${(props) => {
      if (props.focus) {
        return '0.5px solid var(--Line_Heavy)';
      }
      return props.error
        ? '0.5px solid var(--Danger_Clicked)'
        : '0.5px solid var(--Line_Light)';
    }};

    position: relative;
    z-index: 2;
    :hover {
      box-shadow: 0 0 0 2px #c6c5f2;
    } */
    .AdendaTimeItemInput-value-des-container {
      overflow: hidden;
      transition: height 0.3s;
    }

    .AdendaTimeItemInput-value-placeholder {
      position: absolute;
      font-weight: 400;
      font-size: 14px;
      color: var(--Text_Disabled);
      z-index: 1;
    }
    .AdendaTimeItemInput-review {
      position: absolute;
      right: 16px;
      display: none;
    }
  }
  .AdendaTimeItemInput-value {
    font-size: 14px;
    letter-spacing: 0;
    box-sizing: border-box;
    white-space: pre-wrap;
    overflow-wrap: anywhere;
    position: relative;
    z-index: 2;
    color: var(--Text_Caption);
    cursor: pointer;
    /* user-modify: read-write-plaintext-only; */
    -webkit-user-modify: read-write-plaintext-only;
    -webkit-font-smoothing: antialiased;
  }
  .AdendaTimeItemInput-value-des {
    line-height: 20px;
    margin-top: 4px;
    font-size: 12px;
    color: rgba(39, 38, 77, 0.65);
    position: relative;
    -webkit-user-modify: read-write-plaintext-only;
    z-index: 2;
  }
  .m_input_value {
    position: relative;
  }
  .m_placeholder {
    letter-spacing: 0px;
    color: var(--Text_Disabled);
    position: absolute;
    z-index: 1;
    top: 0;
    line-height: 20px;
  }
`;
