import { docTagHooks } from '../../../../../../documentModel';
import { SelectText } from '../../../../../../pages/docASR/components/atomicComponent/common/SelectText';
import { eTheme } from '../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import { toDoReIdState } from '../../../../../../recoils/docFile/reviewContent';
import { TYIcon } from '@tingwujs/design';
import { memo, useCallback, useEffect, useRef, useState } from 'react';
import { useRecoilValue } from 'recoil';
import { useReview } from '../hooks/useReview.hook';
import ToDoItemTitle from './components/ToDoItemTitle';
import { ToDoListProps } from './index.d';
import {
  IconContainer,
  ToDoListContainer,
  ToDoListItem,
  ToDoListItemContent,
} from './styled';

export const ToDoList = memo((props: ToDoListProps) => {
  const {
    data,
    expanded = false,
    style = {},
    theme = eTheme.TAB_ITEM,
    ...rest
  } = props;
  const { docTagData } = docTagHooks.useDocTagData();
  const { audioStatus } = (docTagData || {}) as any;
  const { onToDoListReviewHandler } = useReview();
  const toDoReId = useRecoilValue(toDoReIdState);
  const [containerWidth, setContainerWidth] = useState(0);
  const containerRef = useRef<HTMLDivElement>(null);
  const [showDataheight, setShowDataheight] = useState(40);

  useEffect(() => {
    if (!containerRef.current) return;

    const observer = new ResizeObserver(() => {
      if (!containerRef.current) return;
      const { width } = containerRef.current.getBoundingClientRect();
      setContainerWidth(width - 76);
    });
    observer.observe(containerRef.current);

    return () => {
      observer.disconnect();
    };
  }, [containerRef.current]);

  const onReviewHandler = useCallback(
    (info) => {
      if (!info) return;
      onToDoListReviewHandler(info);
    },
    [onToDoListReviewHandler, data],
  );

  return (
    <ToDoListContainer
      {...rest}
      ref={containerRef}
      theme={theme}
      style={{
        ...style,
        height: `${showDataheight}px`,
        overflow: 'hidden',
      }}
    >
      <div
        ref={(div) => {
          if (div) {
            let _showDataheight = div.clientHeight;
            if (!expanded && data.length > 3) {
              _showDataheight = 120;
            }
            showDataheight !== _showDataheight &&
              setShowDataheight(_showDataheight);
          }
        }}
      >
        {data.map((info, index) => {
          const { id, value } = info;
          return (
            <SelectText
              onClick={() => {
                if (audioStatus === '0') {
                  return;
                }
                onReviewHandler(info);
              }}
            >
              <ToDoListItem
                key={id}
                style={{ marginTop: index > 0 ? '4px' : '0px' }}
                theme={theme}
                focus={theme === eTheme.SUMMARY_ITEM ? id === toDoReId : false}
              >
                <IconContainer>
                  <TYIcon
                    type={'icon-daibanshixiang'}
                    style={{ fontSize: 15, color: 'var(--Fill_Secondary)' }}
                  />
                </IconContainer>

                <ToDoListItemContent
                  style={{
                    width: `${containerWidth}px`,
                  }}
                >
                  <ToDoItemTitle value={value} />
                </ToDoListItemContent>
              </ToDoListItem>
            </SelectText>
          );
        })}
      </div>
    </ToDoListContainer>
  );
});

export default ToDoListItem;
