import {
  docBigModelHooks,
  docTranslateHooks,
} from '../../../../../../../documentModel';
import { useSphereState } from '@tingwujs/sphere';
import { useEffect, useMemo } from 'react';
import { useDataHooks } from '../../../../businessCommon/separateHooks/dataShare';

/**
 * 发言人信息获取
 */
const useInitQA = (flag?: boolean) => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const {
    keyPointsReview, // QA
  } = currentDocBigModelData || {};

  const { docTranslateData } = docTranslateHooks.useDocTranslateData();
  const { bigModelTranslate, translateIsOpen } = docTranslateData || {};
  const { questionAnswerLlm } = bigModelTranslate || {};

  const { qnaController } = useDataHooks();

  useEffect(() => {
    if (!flag) return;
    if (!qnaController) return;

    // 要点回顾|问答回顾
    if (keyPointsReview) {
      // 设置模型  mainPoint 要点回顾 questionAndanswer 问答回顾
      qnaController.setQaModel('mainPoint');
      // 格式化模型数据
      if (keyPointsReview) {
        const list = keyPointsReview.map(({ id, title, value, extensions }) => {
          return {
            qId: id,
            qQuestion: title,
            qAnswer: value,
            extensions: {
              sentenceIdsOfAnswer:
                extensions &&
                extensions[0].sentenceIdsOfAnswer?.map((item) => String(item)),
              sentenceIdsOfQuestion:
                extensions &&
                extensions[0].sentenceIdsOfQuestion?.map((item) =>
                  String(item),
                ),
              sentenceInfoOfAnswer:
                extensions &&
                extensions[0].sentenceInfoOfAnswer?.map((item) => {
                  return { ...item };
                }),
              sentenceInfoOfQuestion:
                extensions &&
                extensions[0].sentenceInfoOfQuestion?.map((item) => {
                  return { ...item };
                }),
            },
          };
        });
        // 设置模型数据
        qnaController.setOriginData({
          questions: list || [],
        });
      }
    }
    return () => {
      // 设置模型数据
      qnaController.setOriginData({
        questions: [],
      });
    };
  }, [flag, keyPointsReview, qnaController]);

  const gistQAList = useSphereState(qnaController, 'displayQnaList') || []; // 要点|问答 列表
  const activeQnaIndex = useSphereState(qnaController, 'activeQnaIndex'); // 当前展示的数据的下标

  const translateIsOpenQAList = useMemo(() => {
    if (gistQAList.length === 0) return [];
    let _gistQAList = gistQAList;
    if (questionAnswerLlm && questionAnswerLlm.length) {
      _gistQAList = gistQAList.map((item) => {
        const _item = {
          ...item,
          answer: { ...item.answer },
          question: { ...item.question },
        };
        const summary = questionAnswerLlm.find((i) => i.id === item.id);
        if (summary && translateIsOpen) {
          _item.answer.title = summary.value || _item.answer.title;
          _item.question.title = summary.title || _item.question.title;
        }
        return _item;
      });
    }
    return _gistQAList;
  }, [gistQAList, questionAnswerLlm, translateIsOpen]);

  const QAList = translateIsOpen ? translateIsOpenQAList : gistQAList;

  return { QAList, activeQnaIndex };
};

export { useInitQA };
