import { eTheme } from '../../../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import styled from 'styled-components';

export const QASummaryComp = styled.div.attrs(({ theme }) => ({
  theme,
}))`
  display: flex;
  gap: 5px;
  flex-direction: column;
  padding: ${({ theme }) =>
    theme === eTheme.SUMMARY_ITEM ? '0 16px 16px' : '0'};
`;

export const QAItemComp = styled.div<{
  theme: any;
  focus?: boolean;
  clear: any;
  editStatus?: boolean;
  editFocus?: boolean;
  error?: boolean;
}>`
  [contenteditable]:focus {
    outline: none;
    font-weight: normal;
  }
  border-radius: 4px;
  display: flex;
  cursor: ${({ theme }) =>
    theme === eTheme.SUMMARY_ITEM ? 'pointer' : 'default'};
  background-color: ${(props) =>
    props.editStatus ? 'var(--Text_Brand_Primary)' : 'var(--Fill_Tertiary)'};
  /* border: ${(props) => {
    if (!props.editStatus) return '0.5px solid transparent';
    if (props.editFocus) {
      return '0.5px solid var(--Line_Heavy)';
    }
    return props.error
      ? '0.5px solid var(--Danger_Clicked)'
      : '0.5px solid var(--Line_Heavy)';
  }}; */

  :hover {
    background-color: var(--Fill_Brand_Tertiary);
    ${(props) =>
      props.editStatus ? 'box-shadow: 0 0 0 2px var(--Line_Heavy)' : ''};
  }
  ${(props) =>
    !props.editStatus &&
    `&:hover {
    background-color: ${props.clear ? 'rgba(96, 92, 229, 0.05)' : ''};
    .QAItem__Review {
      display:  ${
        props.theme === eTheme.SUMMARY_ITEM || props.clear ? 'none' : 'flex'
      };
    }
  }`}

  .QAItem--Left {
    width: 48px;
    background-color: ${({ theme, focus }) =>
      theme === eTheme.SUMMARY_ITEM && focus
        ? 'rgba(136,133,236,1)'
        : 'var(--Fill_Secondary)'};
    border-radius: 4px;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  .QAItem__Icon {
    width: 22px;
  }
  .QAItem--Right {
    flex: 1;
    padding: 12px 20px 12px 12px;
    gap: 4px;
    display: flex;
    flex-direction: column;
    cursor: pointer;
  }
  .QAItem__Content--Top,
  .QAItem__Content--Bottom {
    display: flex;
    gap: 3px;
    align-items: flex-start;
    opacity: ${({ clear }) => (clear ? 0 : 1)};
    transition: opacity 0.3s ease-out;
  }

  .QAItem__Avatar {
    position: relative;
    display: flex;
    align-items: center;
    background-color: var(--Fill_Background_Light);
    border-radius: 10px;
    gap: 7px;
    height: 20px;
    padding-right: 3px;
    font-weight: 500;
    font-size: 12px;
    color: var(--Text_Primary);
    line-height: 20px;
    margin: 2px 0;
    overflow-wrap: break-word;
    &.Answer {
      color: var(--Warning_Clicked);
    }
    &.hiddenAvatar {
      padding: 0 8px !important;
      width: auto !important;
    }
  }
  .QAItem__Avatar_Edit {
    margin: 1px 0;
  }
  .QAItem__Avatar img,
  .QAItem__OtherAvatar {
    width: 20px;
    height: 20px;
  }
  .QAItem__Title {
    font-weight: 500;
    font-size: 14px;
    color: ${({ theme, focus }) =>
      theme === eTheme.SUMMARY_ITEM && focus
        ? '#615ced'
        : 'var(--Text_Primary)'};
    line-height: 24px;
    flex: 1;
  }
  .QAItem__Value {
    font-weight: 400;
    font-size: 12px;
    color: var(--Text_Secondary);
    letter-spacing: 0;
    text-align: justify;
    line-height: 22px;
    /* overflow: hidden;
    text-overflow: ellipsis;
    -webkit-line-clamp: 1;
    display: -webkit-box;
    -webkit-box-orient: vertical; */
  }
  .QAItem__Review {
    align-items: center;
    height: 24px;
    gap: 4px;
    font-weight: 400;
    font-size: 12px;
    color: var(--Text_Primary);
    line-height: 24px;
    cursor: pointer;
    display: none;
    white-space: nowrap;
    position: absolute;
    right: 20px;
    /* padding-left: 4px; */
    /* background-color: #e7e7fb; */
    svg {
      width: 16px;
    }
  }
`;
