import {
  docBaseHooks,
  docSpeakerHooks,
} from '../../../../../../../../../documentModel';
import { SelectText } from '../../../../../../../../../pages/docASR/components/atomicComponent/common/SelectText';
import { eTheme } from '../../../../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import { Tooltip } from '@tingwujs/design';
import classNames from 'classnames';
import { useCallback, useMemo, useRef, useState } from 'react';
import { eEventTitle } from '../../../../BigModel';
import { useSpeaker } from '../../../../BIgModelInput/hooks/useSpeaker.hooks';
import { useReview } from '../../../../hooks/useReview.hook';
import AvatarList from '../../AvatarList';
import { QASummaryItemProps } from '../index.type';
import { QAItemComp } from '../styled';

// 问答回顾项
const QASummaryItem = ({
  theme = eTheme.TAB_ITEM,
  qa,
  clear,
  index,
}: QASummaryItemProps) => {
  const focus = false;
  const { docSpeakerData } = docSpeakerHooks.useDocSpeakerData();
  const { speakersSplitIsLoading } = docSpeakerData || {};
  const { docBaseData } = docBaseHooks.useDocBaseData();
  // 记录所有tooltip的展示情况 (已弃用，但做保留)
  const [tooltipVisible, setTooltipVisible] = useState<boolean>(false);
  // 观察的宽度
  const summaryRef = useRef<any>();
  const { onGistQAReviewHandle } = useReview();

  const { getAvatarNameList } = useSpeaker();
  // 回顾/关闭回顾
  const reviewHandle = useCallback(
    (id) => {
      onGistQAReviewHandle(
        {
          eTitle: eEventTitle.CHANGE_QNA_REVIEW_TAB_EXPANDED,
          info: qa,
          sids: qa.question.sids,
          id,
          index,
          isQA: true,
        },
        docBaseData?.consoleInfo?.taskSourceType,
      );
    },
    [onGistQAReviewHandle, index, docBaseData?.consoleInfo?.taskSourceType],
  );

  /** 渲染 问题 */
  const renderContentTop = useMemo(() => {
    console.log('qa.question?.uid:', qa.question?.uid);
    // 角色分离且角色被删除后不展示
    const showAvatar = !(speakersSplitIsLoading && !qa.question?.uid);
    return (
      <div className="QAItem__Content--Top">
        <div
          className={classNames(
            'QAItem__Avatar',
            showAvatar ? '' : 'hiddenAvatar',
          )}
        >
          {showAvatar && (
            <AvatarList data={getAvatarNameList([qa.question?.uid]) as any} />
          )}
          问:
        </div>

        <div className="QAItem__Title">{qa.question?.title}</div>
      </div>
    );
  }, [qa, getAvatarNameList]);
  /** 渲染答案 */
  const renderContentBottom = useMemo(() => {
    const showAvatar = !(speakersSplitIsLoading && !qa.answer?.uid);
    return (
      <div className="QAItem__Content--Bottom">
        <div
          className={classNames(
            'QAItem__Avatar',
            'Answer',
            showAvatar ? '' : 'hiddenAvatar',
          )}
        >
          {showAvatar && (
            <AvatarList data={getAvatarNameList(qa.answer?.uids) as any} />
          )}
          答:
        </div>
        <div
          className="QAItem__Value"
          ref={summaryRef}
          onMouseEnter={() => {
            if (
              summaryRef.current?.scrollHeight >
              summaryRef.current?.clientHeight
            ) {
              setTooltipVisible(true);
            }
          }}
          onMouseLeave={() => setTooltipVisible(false)}
        >
          {qa.answer?.title}
        </div>
      </div>
    );
  }, [qa, summaryRef.current, getAvatarNameList]);

  // 渲染右侧
  const renderGistItemRight = useMemo(() => {
    return (
      <div className="QAItem--Right">
        {renderContentTop}
        {renderContentBottom}
      </div>
    );
  }, [qa, renderContentTop, renderContentBottom]);

  // 渲染左侧
  const renderGistItemLeft = useMemo(() => {
    return (
      <div className="QAItem--Left">
        <img
          className="QAItem__Icon"
          src={
            'https://img.alicdn.com/imgextra/i3/O1CN01uwXyn21gQLDvAwobz_!!6000000004136-55-tps-21-14.svg'
          }
        />
      </div>
    );
  }, [focus, theme]);

  return (
    <Tooltip
      title={qa.answer?.title}
      visible={!clear && tooltipVisible}
      placement="right"
    >
      <SelectText
        onClick={(e) => {
          e.stopPropagation();
          if (theme !== eTheme.SUMMARY_ITEM) {
            reviewHandle(qa.id);
          }
        }}
      >
        <QAItemComp theme={theme} clear={clear} focus={focus} key={qa?.id}>
          {renderGistItemLeft}
          {renderGistItemRight}
        </QAItemComp>
      </SelectText>
    </Tooltip>
  );
};

export default QASummaryItem;
