import { eTheme } from '../../../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import styled from 'styled-components';
import { SummaryExtractionStyled } from '../../../common/SummaryExtraction';

export const GistSummaryComp = styled.div<{ theme: eTheme }>`
  display: flex;
  gap: 5px;
  margin-top: 2px;
  flex-direction: column;
  ${({ theme }) =>
    theme === eTheme.SUMMARY_ITEM ? 'padding: 0px 16px 10px 16px' : ''};
`;

interface GistItemCompProps {
  theme: any;
  focus?: boolean;
  editStatus?: boolean;
  error?: boolean;
}

export const GistItemComp = styled(SummaryExtractionStyled)<GistItemCompProps>`
  border-radius: 4px;

  cursor: ${({ theme }) =>
    theme === eTheme.SUMMARY_ITEM ? 'pointer' : 'default'};
  display: flex;
  padding: 12px 20px 12px 0;
  overflow: hidden;
  &:hover {
    /* ${(props) =>
      props.editStatus ? 'box-shadow: 0 0 0 2px #c6c5f2' : ''}; */
    /* background-color: ${(props) =>
      props.editStatus ? '#fff' : 'var(--TY-Fill-Brand-2)'};
    border-color: ${(props) => (props.editStatus ? '' : 'var(--TY-Link-1)')};
    .GistItem__Review {
      display: ${(props) => (props.editStatus ? 'none' : 'flex')};
    } */
  }
  .GistItem--Left {
    padding-left: 13px;
    padding-right: 12px;
  }
  .GistItem__Icon {
    margin-top: 2px;
    width: 40px;
  }
  .GistItem--Right {
    flex: 1;
    cursor: pointer;
    [contenteditable]:focus {
      outline: none;
      font-weight: normal;
    }
  }
  .GistItem__Content--Top {
    display: flex;
    margin-bottom: 4px;
  }
  .GistItem__Title {
    font-weight: 500;
    font-size: 14px;
    color: var(--Text_Primary);
    letter-spacing: 0;
    line-height: 24px;
    flex: 1;
  }
  .GistItem__Review {
    align-items: center;
    height: 24px;
    gap: 4px;
    font-weight: 400;
    font-size: 12px;
    color: #615ced;
    line-height: 24px;
    cursor: pointer;
    display: none;
    white-space: nowrap;
    position: absolute;
    right: 20px;
    /* padding-left: 4px; */
    /* background-color: #e7e7fb; */
    svg {
      width: 14px;
    }
  }
  .GistItem__Content--Middle {
    font-weight: 400;
    font-size: 12px;
    color: var(--Text_Caption);
    letter-spacing: 0;
    text-align: justify;
    line-height: 20px;
  }
  .GistItem__Content--Bottom {
    margin-top: 8px;
  }
  .GistItem__Spokesman {
    display: flex;
    align-items: center;
    gap: 6px;
  }
  .GistItem__Spokesman--Left {
    position: relative;
    display: flex;
  }
  .GistItem__Spokesman--Right {
    font-weight: 400;
    font-size: 12px;
    color: var(--Text_Caption);
    line-height: 20px;
  }
`;
