import React, { memo } from 'react';
import GistItem from './GistItem';
import { GistProps } from './index.type';
import { GistSummaryComp } from './styled';

// 要点回顾
const GistSummary: React.FC<GistProps> = memo((props) => {
  console.log('props', props);
  return (
    <GistSummaryComp theme={props.theme}>
      {props.data?.map((gist, index) => (
        <GistItem key={gist.id} gist={gist} index={index} {...props} />
      ))}
    </GistSummaryComp>
  );
});

export default GistSummary;
