import { oneHour } from '../../../../../../../pages/docASR/utils/config';
import { Presentation, PresentationAgenda } from '@tingwujs/sphere';
import React, { Fragment, useEffect, useRef, useState } from 'react';
import { useInitPPT } from '../hooks/useInitPPT.hooks';
import PPTSummaryCardList from '../PPTSummaryCardList';
import PPTSummaryList from '../PPTSummaryList';
import { PPTSummaryMapContainer } from './styled';

export interface PPTAgenda {
  id: string;
  agendaHeading: string;
  beginTime: number;
  endTime: number;
  photo: string;
}

const PPTSummaryMap = ({
  alls,
  pptAgendas,
  pptsMap,
  pptlist,
  shortMode,
  transId,
  scrollIntoViewPPTRef,
}: {
  alls: boolean;
  pptAgendas?: PresentationAgenda[];
  pptlist: Presentation[];
  shortMode?: boolean;
  scrollIntoViewPPTRef?: { current: any };
  pptsMap: Record<
    string,
    {
      ppts: Presentation[];
    }
  >;
  transId: string;
}) => {
  const { modelType: type = 'detail' } = useInitPPT();
  const [containerHeight, setContainerHeight] = useState(0);
  const containerRef = useRef<HTMLDivElement>(null);
  const nodeRef = useRef<HTMLDivElement>(null);
  let hideHeight = 0;
  if ((pptAgendas?.length || 0) > 0) {
    if (type === 'detail') {
      hideHeight = 184;
    } else {
      hideHeight = 199;
    }
  } else if (type === 'detail') {
    hideHeight = 140;
  } else {
    hideHeight = 157;
  }

  useEffect(() => {
    // fix 50740912
    // const root = document.getElementById('root');
    // if (root) {
    //   root.style.overflow = 'hidden';
    // }

    const observer = new ResizeObserver(() => {
      if (!nodeRef.current || !containerRef.current) return;
      let childHeights = 0;
      Array.prototype.forEach.call(
        containerRef.current.childNodes,
        (node: HTMLElement) => {
          const { height } = node.getBoundingClientRect();
          childHeights += height;
        },
      );
      setContainerHeight(childHeights);
    });
    if (nodeRef.current) {
      observer.observe(nodeRef.current);
    }
    return () => {
      observer.disconnect();
    };
  }, [containerRef.current, nodeRef.current]);

  const pptRef = React.useRef({ pptListLength: pptlist.length });

  useEffect(() => {
    if (pptlist) {
      pptRef.current.pptListLength = pptlist.length;
    }
  }, [pptlist]);

  useEffect(() => {
    setTimeout(() => {
      if (pptRef.current.pptListLength && containerRef.current) {
        let childHeights = 0;
        Array.prototype.forEach.call(
          containerRef.current?.childNodes,
          (node: HTMLElement) => {
            const { height } = node.getBoundingClientRect();
            childHeights += height;
          },
        );
        setContainerHeight(childHeights);
      }
    }, 0);
  }, [pptRef.current.pptListLength, pptlist, containerRef.current]);

  return (
    <PPTSummaryMapContainer
      ref={containerRef}
      style={{ height: alls ? `${containerHeight}px` : `${hideHeight}px` }}
    >
      <div ref={nodeRef} className="PPTSummaryMapContainer_content">
        {pptAgendas && pptAgendas?.length > 0 ? (
          <Fragment>
            {pptAgendas.map((pptAgenda, index) => {
              let isOverOneHour = false;
              pptAgendas.some((agenda: any) => {
                if (Number(agenda.beginTime) >= oneHour) {
                  isOverOneHour = true;
                  return true;
                }
                return false;
              });

              if (type === 'detail') {
                const ppts = pptsMap[pptAgenda.id]?.ppts || [];
                let prePPTs: any[] = [];
                if (index > 0) {
                  prePPTs = pptsMap[pptAgendas[index - 1].id]?.ppts || [];
                }
                return (
                  <PPTSummaryList
                    isOverOneHour={isOverOneHour}
                    key={pptAgenda.beginTime}
                    index={index}
                    titleInfo={pptAgenda}
                    pptList={ppts}
                    preValue={prePPTs.length > 0}
                    lastIndex={
                      index === pptAgendas.length - 1 && ppts.length === 0
                    }
                    lastPPTIndex={index === pptAgendas.length - 1}
                    shortMode={shortMode}
                    transId={transId}
                    scrollIntoViewPPTRef={scrollIntoViewPPTRef}
                  />
                );
              } else if (type === 'simple') {
                const ppts = pptsMap[pptAgenda.id]?.ppts || [];
                let prePPTs: any[] = [];
                if (index > 0) {
                  prePPTs = pptsMap[pptAgendas[index - 1].id]?.ppts || [];
                }
                return (
                  <PPTSummaryCardList
                    isOverOneHour={isOverOneHour}
                    scrollIntoViewPPTRef={scrollIntoViewPPTRef}
                    key={pptAgenda.beginTime}
                    index={index}
                    pptListLength={pptlist.length}
                    preValue={prePPTs.length > 0}
                    titleInfo={pptAgenda}
                    pptList={ppts}
                    shortMode={shortMode}
                    transId={transId}
                  />
                );
              } else {
                return null;
              }
            })}
          </Fragment>
        ) : (
          <Fragment>
            {type === 'detail' ? (
              <PPTSummaryList
                key={pptlist.length > 0 ? pptlist[0].beginTime : 0}
                pptList={pptlist}
                index={0}
                shortMode={shortMode}
                isAgendaNull
                lastPPTIndex
                transId={transId}
                isMergeList={false}
                scrollIntoViewPPTRef={scrollIntoViewPPTRef}
                isOverOneHour
              />
            ) : (
              <PPTSummaryCardList
                key={pptlist.length > 0 ? pptlist[0].beginTime : 0}
                index={0}
                pptListLength={pptlist.length}
                pptList={pptlist}
                shortMode={shortMode}
                isAgendaNull
                transId={transId}
                scrollIntoViewPPTRef={scrollIntoViewPPTRef}
                isOverOneHour
              />
            )}
          </Fragment>
        )}
      </div>
    </PPTSummaryMapContainer>
  );
};

export default PPTSummaryMap;
