import React, { Fragment, memo, useCallback, useRef } from 'react';

import { pptReViewInfoStatus } from '../../../../../../../recoils';
import { getFlexibleTime } from '@tingwujs/common';
import { Tooltip } from '@tingwujs/design';
import { Skeleton } from 'antd';
import { useSetRecoilState } from 'recoil';
import { SelectText } from '../../../common/SelectText';
import { useReview } from '../../hooks/useReview.hook';
import { PPTSummaryItemProps } from './pptSummaryItem';
import {
  PPTItemContainer,
  PPTItemContentContainer,
  PPTPhotoContainer,
} from './style';
const PPTSummaryItem = memo(
  ({
    custom,
    index,
    lastIndex,
    info,
    shortMode,
    isAgendaNull,
    isOverOneHour,
  }: PPTSummaryItemProps) => {
    const { onPPTReviewHandler } = useReview();
    const contentRef: React.RefObject<HTMLDivElement> = useRef<any>();
    const setPptReViewInfo = useSetRecoilState(pptReViewInfoStatus);

    const onReviewHandler = useCallback(
      (e) => {
        e.stopPropagation();
        onPPTReviewHandler(info);
      },
      [onPPTReviewHandler],
    );
    const [zIndex, setZIndex] = React.useState(-1);
    const ref: any = React.useRef();

    React.useEffect(() => {
      const observer = new ResizeObserver(() => {
        if (ref.current) {
          setTimeout(() => {
            if (ref.current?.scrollHeight > ref.current?.clientHeight) {
              setZIndex(600);
            } else {
              setZIndex(-1);
            }
          }, 0);
        }
      });
      if (ref.current) {
        observer.observe(ref.current);
      }

      return () => {
        observer.disconnect();
      };
    }, [ref, ref.current]);

    const onPhotoViewer = (e) => {
      e.stopPropagation();
      setPptReViewInfo(info);
    };

    return (
      <Tooltip
        title={
          <div
            style={{
              maxWidth: 320,
              maxHeight: `${document.body.clientHeight * 0.8}px`,
              overflow: 'auto',
            }}
          >
            {Array.isArray(info.content) ? (
              <div>
                {info.content.map((item) => {
                  return (
                    <div key={item}>
                      <span>{item}</span>
                    </div>
                  );
                })}
              </div>
            ) : (
              info.content
            )}
          </div>
        }
        zIndex={zIndex}
        open={false}
        placement="right"
        getPopupContainer={() =>
          document.getElementById('tingwu2_file_container') as any
        }
      >
        <PPTItemContainer
          className="tingwu2_ppt_item"
          data-time={info.beginTime}
          data-custom={!custom && !info.content}
          ref={contentRef}
          key={info.beginTime}
        >
          <div className="pptItem-left">
            <div className="pptItem-left-time">
              {info.beginTime !== undefined ? (
                <div
                  className="pptItem-time"
                  style={{ width: isOverOneHour ? '68px' : '46px' }}
                >
                  <div className="pptItem-time-content">
                    {location.search.includes('debug')
                      ? `${info.index}&${info.id}`
                      : getFlexibleTime(info.beginTime)}
                  </div>
                </div>
              ) : (
                <div
                  className="pptItem-time"
                  style={{ width: isOverOneHour ? '68px' : '46px' }}
                />
              )}
              {!(index === 0 && isAgendaNull) ? (
                <div className="pptItem-left-dashed">
                  <div
                    style={{
                      display: 'inline-block',
                      width: 1,
                      height: 803,
                      borderRight: '1px dashed var(--Line_Heavy)',
                    }}
                  />
                </div>
              ) : null}
              <div className={`pptItem-dot`} />
            </div>
            {!lastIndex ? (
              <div className="pptItem-right-dashed">
                <div
                  style={{
                    display: 'inline-block',
                    width: 1,
                    height: 803,
                    borderRight: '1px dashed var(--Line_Heavy)',
                  }}
                />
              </div>
            ) : null}
          </div>
          <SelectText
            className="pptItem-content"
            style={index === 0 ? { paddingTop: 0 } : {}}
            onClick={onReviewHandler}
          >
            <PPTItemContentContainer
              className={`${shortMode ? 'pptItem-value-out-short' : ''}`}
            >
              <PPTPhotoContainer
                className={`${
                  info.radius ? 'pptItem-photo-content-others' : ''
                }${shortMode ? ' pptItem-value-photo-short' : ''}`}
                onMouseUp={(e) => {
                  e.stopPropagation();
                }}
                onClick={onPhotoViewer}
              >
                <div
                  className={`pptItem-value-photo${
                    info.radius ? '' : ' pptItem-value-photo-out'
                  }
                ${shortMode ? ' pptItem-value-photo-short' : ''}`}
                  // style={{ backgroundImage: `url(${info.photo})` }}
                >
                  {info.radius ? (
                    <Fragment>
                      <div
                        className="pptItem-value-photo-img-content"
                        style={{
                          width: shortMode ? 161 : 196,
                          height: shortMode ? 90 : 110,
                        }}
                      >
                        <img
                          src={info.pictureKey}
                          style={{
                            width: shortMode ? 159 : 194,
                            height: shortMode ? 88 : 108,
                            objectFit: 'contain',
                            zIndex: 10,
                            boxShadow: '1px 0 3px 0 #E5E8F2',
                            display: 'block',
                            borderRadius: 2,
                            position: 'relative',
                          }}
                        />
                      </div>
                      <div
                        style={{
                          position: 'absolute',
                          top: 0,
                          width: '100%',
                          height: '100%',
                          backgroundColor: 'white',
                          left: 7,
                          boxShadow: '1px 0 3px 0 #E5E8F2',
                          borderRadius: 2,
                        }}
                      />
                    </Fragment>
                  ) : (
                    <img
                      src={info.pictureKey}
                      style={{
                        width: shortMode ? 161 : 196,
                        height: shortMode ? 90 : 110,
                        objectFit: 'contain',
                      }}
                    />
                  )}
                </div>
              </PPTPhotoContainer>
              <Skeleton
                loading={info.isLoadingContent}
                title={false}
                active
                paragraph={{ rows: 3 }}
              >
                <Fragment>
                  {info.content ? (
                    <div
                      className={`pptItem-value-des${
                        info.radius ? ' pptItem-value-des-others' : ''
                      }${shortMode ? ' pptItem-value-des-short' : ''}`}
                    >
                      <div style={{ position: 'relative' }}>
                        <div
                          ref={ref}
                          style={{ position: 'relative', paddingLeft: 0 }}
                        >
                          {Array.isArray(info.content)
                            ? info.content.map((item) => {
                                return (
                                  <div style={{ minHeight: 15 }} key={item}>
                                    <span>{item}</span>
                                  </div>
                                );
                              })
                            : info.content}
                        </div>
                      </div>
                    </div>
                  ) : (
                    <div
                      ref={ref}
                      className={`pptItem-value-des${
                        info.radius ? ' pptItem-value-des-others' : ''
                      }${info.content ? '' : ' pptItem-value-des-empty'}${
                        shortMode ? ' pptItem-value-des-short' : ''
                      }`}
                      style={{ color: '#c8cad9' }}
                    >
                      {!custom
                        ? '本页是截图，没有总结内容哦'
                        : '没有总结内容哦'}
                    </div>
                  )}
                </Fragment>
              </Skeleton>
            </PPTItemContentContainer>
          </SelectText>
        </PPTItemContainer>
      </Tooltip>
    );
  },
);

export default PPTSummaryItem;
