import styled from 'styled-components';

export const PPTAdengeContainer = styled.div<{ type: string }>`
  display: flex;
  position: relative;
  [contenteditable]:focus {
    outline: none;
    font-weight: normal;
    color: var(--Text_Primary);
  }
  .pptAdenge-backtrack {
    position: absolute;
    top: 0;
    left: 0;
  }
  .pptAdenge-value-out {
    width: 100%;
    border-radius: 4px;
    position: relative;
    display: flex;
    .pptAdenge-value-photo {
      width: 200px;
      height: 112.5px;
    }
    .pptAdenge-value-des {
      /* margin-top: 4px; */
      font-weight: 400;
      font-size: 14px;
      color: var(--Text_Primary);
      letter-spacing: 0;
      line-height: 29px;
      .pptSmallItem-value-des-value {
        word-break: break-all;
        text-overflow: -o-ellipsis-lastline;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;

        -webkit-box-orient: vertical;
      }
      .pptSmallItem-value-des-value-line {
        -webkit-line-clamp: 1;
      }
      .pptSmallItem-value-des-value-two-line {
        -webkit-line-clamp: 2;
      }
    }
    .pptAdenge-value-placeholder {
      position: absolute;
      font-weight: 400;
      font-size: 14px;
      color: var(--Text_Disabled);
      z-index: 1;
    }
    .pptAdenge-review {
      position: absolute;
      right: 16px;
      display: none;
    }
  }
  .pptAdenge-value-line {
    word-break: break-all;
    text-overflow: -o-ellipsis-lastline;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 1;
    -webkit-box-orient: vertical;
  }
  .pptAdenge-value {
    font-size: 14px;
    letter-spacing: 0;
    box-sizing: border-box;
    white-space: pre-wrap;
    overflow-wrap: anywhere;
    position: relative;
    z-index: 2;
    color: var(--Text_Primary);
    cursor: pointer;
    -webkit-font-smoothing: antialiased;
  }

  .pptAdenge-left {
    margin-right: 16px;
    position: relative;
    user-select: none;
    .pptAdenge-left-time {
      height: 42px;
      display: flex;
      align-items: center;
      position: relative;
      cursor: default;
      user-select: none;
      /* :hover{
      >.pptAdenge-dot{
        box-shadow: rgb(96 92 229 / 20%) 0px 0px 0px 3px;
       }
    } */
      > .pptAdenge-time {
        width: 46px;
        /* width: 68px; */
        font-family: PingFangSC, var(--font-family);
        font-weight: 400;
        font-size: 12px;
        color: var(--Text_Primary);
        letter-spacing: 0;
        user-select: none;
        position: relative;
        .pptAdenge-time-content {
          position: absolute;
          right: 7px;
          top: -8px;
        }
      }
      > .pptAdenge-dot {
        height: 8px;
        width: 8px;
        background-color: var(--Text_Caption);
        border-radius: 10px;
        user-select: none;
      }
      > .pptAdenge-left-dashed {
        position: absolute;
        right: 4px;
        top: 0;
        height: 11px;
        overflow: hidden;
        user-select: none;
      }
    }
    .pptAdenge-right-dashed {
      display: flex;
      justify-content: flex-end;
      position: absolute;
      right: 4px;
      top: 33px;
      bottom: 0;
      overflow: hidden;
      user-select: none;
    }
  }
  .pptAdenge-right {
    width: 100%;
    padding-top: 6px;
    ${({ type }) => (type === 'simple' ? 'margin-left: -6px;' : '')};
  }
`;
export const PPTLine = styled.div`
  position: relative;
  height: 9px;
  overflow: hidden;
  .pptAdenge-dashed {
    position: absolute;
    height: 100%;
    overflow: hidden;
    left: 49px;
  }
`;
export const PPTTitleContainer = styled.div<{
  editStatus?: boolean;
  error?: boolean;
  focus?: boolean;
  type: string;
}>`
  position: relative;
  cursor: pointer;
  /* :hover {
    ${(props) => (props.editStatus ? 'box-shadow: 0 0 0 2px #c6c5f2' : '')};
  } */
  :hover {
    border-color: ${(props) => (props.editStatus ? 'var(--Line_Heavy)' : '')};
  }
  border: ${(props) => {
    if (!props.editStatus) return '';
    if (props.focus) {
      return '0.5px solid var(--Line_Heavy)';
    }
    return props.error
      ? '0.5px solid var(--Danger_Clicked)'
      : '0.5px solid var(--Line_Light)';
  }};
  ${({ editStatus }) => {
    if (editStatus) {
      return `border-radius: 4px;
  background: var(--Fill_Background_Light);
  padding-left: 10px;
  height: 100%;
  display: flex;
  align-items: center;
`;
    }
  }}
`;
