import { documentHooks } from '../../../../../../documentModel';
import {
  docBigModelHooks,
  eLabInfoStatus,
} from '../../../../../../documentModel/docBigModel';
import { pptReViewInfoStatus } from '../../../../../../recoils/docFile/reviewContent';
import bus from '../../../../../../utils/bus';
import { ExtractPpt, PresentationAgenda } from '@tingwujs/sphere';
import { memo, useCallback } from 'react';
import { useRecoilState } from 'recoil';
import { DocPlayerEvts } from '../../../businessCommon/DocMediaPlayer';
import { useDataHooks } from '../../../businessCommon/separateHooks/dataShare';
import { useInitPPT } from './hooks/useInitPPT.hooks';

const PPTPhotoViewer = memo(() => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const {
    pptTitleInfosStatus: agendaSummaryStatus, // 章节速览状态
    pptSummaryLoading: pptsummaryLoading,
  } = currentDocBigModelData || {};
  const agendasLoading = agendaSummaryStatus === eLabInfoStatus.LOADING;
  const { documentData } = documentHooks.useDocumentData();

  const { docId: transId } = documentData || {};
  const { presentationSummaryController, controller, aiAssistantController } =
    useDataHooks();
  const { pptAgendas, pptsMap, pptlist } = useInitPPT();

  const [pptReViewInfo, setPptReViewInfo] = useRecoilState(pptReViewInfoStatus);

  const onClose = () => {
    setPptReViewInfo(undefined);
  };

  const onReviewHandler = useCallback(
    (time) => {
      onClose();
      if (controller) {
        controller.startPlayingVoiceWord();
      }
      // bus.emit(CURRENTTIME_TINGWU2, time);
      controller.setPlayingVoiceWordByTime(time);
      aiAssistantController.setTranslateMode();
      bus.emit(DocPlayerEvts.PLAYER_TO_TIME, time);
    },
    [onClose, transId],
  );

  // 没有议程的情况下

  const _pptAgendas = [...pptAgendas];

  const _pptsMap = { ...pptsMap };

  if (pptAgendas.length === 0 && pptlist.length !== 0) {
    const agenda: PresentationAgenda = {
      agendaHeading: '',
      beginTime: pptlist[0].beginTime,
      endTime: pptlist[pptlist.length - 1].beginTime,
      id: `${1}`,
    };
    _pptAgendas.push(agenda);
    _pptsMap[agenda.id] = { ppts: pptlist };
  }

  if (!pptReViewInfo) {
    return null;
  }

  return (
    <ExtractPpt
      agendas={_pptAgendas}
      pptsMap={_pptsMap}
      chooseId={pptReViewInfo.id}
      agendasLoading={agendasLoading}
      pptsummaryLoading={pptsummaryLoading}
      // pptList={pptlist}
      onCopySuccess={undefined as any}
      pController={presentationSummaryController}
      closePpt={onClose as any} // 关闭
      onReviewHandler={onReviewHandler as any} // 回溯，需要传time； startTime
      onDelete={undefined}
      onExport={undefined}
      // onDelete={isShare ? undefined : onDelete} // 如果函数为空：不需要提供删除功能 ；删除，需要传pptId
      // onExport={isShare ? (undefined as any) : (onExport as any)} // 如果函数为空：不需要提供导出功能 ；导出，需要传pptId；不传pptid意味着导出全部
    />
  );
});

export default PPTPhotoViewer;
