import React, {
  forwardRef,
  useCallback,
  useEffect,
  useMemo,
  useState,
} from 'react';
import { useRecoilState } from 'recoil';

/** 组件 */
import Empty from '../common/Empty';
import KeywordItem from './KeywordItem';
import { allsKeywordState } from '../../../../../../recoils/docFile/bigModuleRelated';
import { keyWordListState } from '../../../../../../recoils/docFile/keyWord';
/** 接口 hooks */
import {
  docBigModelHooks,
  docTranslateHooks,
} from '../../../../../../documentModel';
import { LabCardsValues } from '../../../../../../pages/docASR/components/atomicComponent/WuLab';
/** 样式引入 */
import { dataAutologs } from '../../../../../../pages/docASR/utils/dataAutologs';
import { ExpanderContainer, KeywordContainer } from './styled';
const defaultItemHeight = 40; // 关键字默认高度

const Keyword = () => {
  const {
    currentDocBigModelData: {
      keyWordInfo: keywordInfo, // 关键词【源语言】数据
    } = {},
  } = docBigModelHooks.useDocBigModelData();
  const {
    docTranslateData: {
      bigModelTranslate: { keyWordsExtractor = [] } = {}, // 关键词【翻译】数据
      translateIsOpen, // 翻译是否开启
    } = {},
  } = docTranslateHooks.useDocTranslateData();

  const [list, setList] = useRecoilState(keyWordListState); // 关键字展示列表【编辑状态】
  /** 当前展示的关键字列表【非编辑状态】 */
  const currentKeywordList: LabCardsValues[] = useMemo(() => {
    const keyWordContent =
      translateIsOpen && keyWordsExtractor && keyWordsExtractor.length > 0
        ? (keyWordsExtractor as any)
        : keywordInfo;
    return keyWordContent;
  }, [keyWordsExtractor, keywordInfo, translateIsOpen]);

  // 其他控制
  const [settingDown, setSettingDown] = useState(false);
  // const keyWordsRef = useRef<HTMLDivElement>(null); // 关键字组件

  const [allsKeyword, setAllsKeyword] = useRecoilState(allsKeywordState); // 记录是否是收起关键词

  // 关键词容器高度
  const [keyWordContainerHeight, setKeyWordContainerHeight] =
    useState(defaultItemHeight);

  useEffect(() => {
    setList(currentKeywordList || []);
  }, [currentKeywordList, setList]);

  /** 切换收起和展开 */
  const onKeywordSwitch = useCallback(() => {
    setAllsKeyword(!allsKeyword);
  }, [allsKeyword, setAllsKeyword]);

  /** 【渲染】非编辑态关键字 */
  const renderKeywordContainer = useMemo(() => {
    // 关键词容器高度
    let _keyWordContainerHeight = `${defaultItemHeight}px`;
    if (allsKeyword) {
      _keyWordContainerHeight = `${keyWordContainerHeight}px`;
    }
    if (list.length === 0) {
      _keyWordContainerHeight = 'auto';
    }
    return (
      <KeywordContainer>
        <div
          style={{
            overflow: 'hidden',
            height: _keyWordContainerHeight,
            transition: 'height 0.3s',
            width: '100%',
          }}
        >
          <div
            style={{
              display: 'flex',
              flexWrap: 'wrap',
            }}
            ref={(div) => {
              if (div) {
                setKeyWordContainerHeight(div.offsetHeight);
                const { height } = div.getBoundingClientRect();
                setSettingDown(height > 41);
              }
            }}
            data-e2e-test-id="trans_keyWord_div"
          >
            {list.map((item: LabCardsValues) => (
              <KeywordItem value={item.value} key={item.value} />
            ))}
            {list.length === 0 ? (
              <div style={{ marginTop: 10, fontSize: '14px' }}>
                <Empty text="暂无关键词" />
              </div>
            ) : null}
          </div>
        </div>

        {/* 展开全部 & 收起 */}
        {settingDown && (
          <ExpanderContainer>
            <div
              onClick={onKeywordSwitch}
              data-e2e-test-id="trans_toogleDown_icon"
              data-autolog={
                allsKeyword ? undefined : dataAutologs.keywordExpand
              }
            >
              <div>{allsKeyword ? '收起' : '展开全部'}</div>
            </div>
          </ExpanderContainer>
        )}
      </KeywordContainer>
    );
  }, [keyWordContainerHeight, list, settingDown, onKeywordSwitch, allsKeyword]);

  return renderKeywordContainer;
};

export default forwardRef(Keyword);
