import { docBaseHooks, documentHooks } from '../../../../../../documentModel';
import { LabCardsValues } from '../../../../../../pages/docASR/components/atomicComponent/WuLab';
import React, { useState } from 'react';
import { useRecoilState } from 'recoil';
import { ButtonsContainer, HeadingTabsContainer } from '../Agenda/styled';
import { HeadingTabs } from './HeadingTabs';

import { titleGeneratorInfoState } from '../../../../../../recoils/docFile';

const RenderedTitle = ({
  // lang,
  tabs,
  tabRef,
  // shortMode,
  currentTab,
  onClickTab,
  // model,
  pptDotVisible,
  agendaEditStatus,
  onCloseEdit,
  // onOKEdit,
  loading,
}: {
  // lang: string;
  tabs: any;
  tabRef: any;
  currentTab: string;
  pptDotVisible: boolean;
  agendaEditStatus: boolean;
  // model?: eDocScene;
  onClickTab: (e: any) => void;
  onCloseEdit?: () => void;
  loading: boolean;
}) => {
  const { docBaseData: { shortMode = false } = {} }: any =
    docBaseHooks.useDocBaseData() || {}; // const {
  //   documentData: { docScene },
  // }: any = documentHooks.useDocumentData();

  const [titleGeneratorInfo] = useRecoilState<any>(titleGeneratorInfoState);
  const [, setAgendaList] = useState<LabCardsValues[] | undefined>();

  React.useEffect(() => {
    if (titleGeneratorInfo) {
      // 0630 去掉只有时间没有内容的议程
      const _list = [...titleGeneratorInfo].filter((item) => item.value);
      setAgendaList(_list);
    } else {
      setAgendaList([]);
    }
  }, [titleGeneratorInfo]);

  return (
    <HeadingTabsContainer ref={tabRef}>
      <HeadingTabs
        shortMode={shortMode}
        tabs={tabs}
        value={currentTab}
        onClickTab={onClickTab}
        dotVisible={pptDotVisible}
        // model={docScene}
      />
      {agendaEditStatus ? (
        <ButtonsContainer>
          <div
            className={`m_cancel${loading ? ' m_loading_cancel' : ''}`}
            onClick={onCloseEdit}
          >
            取消
          </div>
          <div className="m_line" />
          <div className={`m_confirm${loading ? ' m_loading' : ''}`}>
            {loading ? '提交中...' : '确定'}
          </div>
        </ButtonsContainer>
      ) : null}
    </HeadingTabsContainer>
  );
};

export default RenderedTitle;
