import { documentHooks } from '../../../../../../../documentModel';
import React, { memo } from 'react';
import { TabItem, TabItemDot, TabItemInner, Wrapper } from './styled';

export interface HeadingTabsProps {
  tabs: Array<{
    label: string;
    value: string;
    dot?: boolean;
    dataAutolog?: string;
  }>;
  value: string;
  isOnly?: boolean;
  shortMode?: boolean;
  dotVisible?: boolean;
  dotStyle?: any;
  onClickTab?: (value: string) => void;
}

export const HeadingTabs: React.FC<HeadingTabsProps> = memo((props) => {
  const { tabs, value, shortMode, dotVisible, dotStyle, isOnly, onClickTab } =
    props;
  const { documentData } = documentHooks.useDocumentData();
  const { docScene } = documentData || {};
  return (
    <Wrapper isOnly={isOnly}>
      {tabs.map((tab) => {
        const isActived = tab.value === value;
        return (
          <TabItem shortMode={shortMode} key={tab.value}>
            <TabItemInner
              active={isActived}
              model={docScene}
              only={tabs.length === 1}
              data-autolog={tab.dataAutolog}
              onClick={onClickTab ? () => onClickTab(tab.value) : undefined}
            >
              {tab.label}
            </TabItemInner>

            {dotVisible && tab.dot ? <TabItemDot style={dotStyle} /> : null}
          </TabItem>
        );
      })}
    </Wrapper>
  );
});
