import { Tooltip, TYIcon } from '@tingwujs/design';
import { Icon } from '@tingwujs/meeting-icon';
import { SummaryAnimation } from '@tingwujs/sphere';
import React, { useMemo } from 'react';

import { IntelligenceLoading } from './IntelligenceLoading';
import BigModelTabs from '../BigModelTabs';
import BusKeyWord from '../Fragmented/BusKeyWord';

/** 新版数据引用 */
// 第三方

import {
  docBaseHooks,
  docBigModelHooks,
  documentHooks,
  eDocScene,
  eTranscriptionLanguage,
} from '../../../../../../documentModel';
import { useDataHooks } from '../../../../../../pages/docASR/components/businessCommon/separateHooks/dataShare';

import { quickLookHelpTip } from '../../../../../../pages/docASR/utils/config';
import EmptyPage from '../EmptyPage';
import './index.less';
import { FileWulabContainer, QuickLook, ToTopButton } from './styled';

const FileWulab = () => {
  const { docBaseData: { tag } = {} } = docBaseHooks.useDocBaseData();

  const { currentDocBigModelData, isDocBigModelDataHasValue } =
    docBigModelHooks.useDocBigModelData();

  const { lang, hasPPT } = tag || {};

  const { controller } = useDataHooks();

  const stateRef = React.useRef<{
    scrollContainer: any;
    scrollContainerInner: any;
  }>({
    scrollContainer: null,
    scrollContainerInner: null,
  });

  const [toTopVisible, setToTopVisible] = React.useState(false);

  React.useEffect(() => {
    const scrollContainer = document.getElementById(
      'tingwu_wulab_scrollContainer',
    );
    const scrollContainerInner = document.getElementById(
      'tingwu_wulab_scrollContainerInner',
    );
    if (scrollContainer) {
      stateRef.current.scrollContainer = scrollContainer;
    }
    if (scrollContainerInner) {
      stateRef.current.scrollContainerInner = scrollContainerInner;
    }
  }, []);

  const onScroll = () => {
    const { scrollContainerInner, scrollContainer } = stateRef.current;
    if (scrollContainerInner && scrollContainer) {
      const { top } = scrollContainerInner.getClientRects()[0];
      const { top: scrollContainerTop } = scrollContainer.getClientRects()[0];
      const scrollTop = Math.abs(top - scrollContainerTop);
      if (scrollTop > 300) {
        setToTopVisible(true);
      } else {
        setToTopVisible(false);
      }
    }
  };

  const ToTopView = React.useMemo(() => {
    if (!toTopVisible) return;
    const toTop = (e: any) => {
      e.stopPropagation();
      const { scrollContainerInner } = stateRef.current;
      // 滚动到顶部
      scrollContainerInner.scrollIntoView(); // 元素的顶端将和其所在滚动区的可视区域的顶端对齐
      document.documentElement.scrollTop = 0; // 火狐浏览器会引起滚动，清楚这个滚动带来的影响
    };
    return (
      <Tooltip title="回到顶部" placement={'left'}>
        <ToTopButton onClick={toTop} bottom={108}>
          <TYIcon type="tongyi-top-line" />
        </ToTopButton>
      </Tooltip>
    );
  }, [toTopVisible]);

  const quickLookVisible = useMemo(() => {
    if (
      lang === eTranscriptionLanguage.ja &&
      currentDocBigModelData?.normalLabInfoLoading === false &&
      !currentDocBigModelData?.pptSummaryInfos?.contents.length &&
      !currentDocBigModelData?.pptSummaryInfos?.hasPic
    )
      return false;
    return true;
  }, [lang, currentDocBigModelData]);

  const isEmptyBigModel = useMemo(() => {
    // 目前只有无ppt的日语，智能能力为空
    if (lang === eTranscriptionLanguage.ja && !hasPPT) return true;
    return false;
  }, [lang, hasPPT]);
  return (
    <>
      <FileWulabContainer onScroll={onScroll} id="tingwu_wulab_scrollContainer">
        {isEmptyBigModel ? (
          <EmptyPage title="没有智能速览哦" />
        ) : (
          <>
            <div
              id="tingwu_wulab_scrollContainerInner"
              style={{
                wordWrap: 'break-word',
                overflowWrap: 'anywhere',
              }}
            >
              {/* 智能速览的标题和提示 */}
              {quickLookVisible &&
                ![
                  String(eTranscriptionLanguage.cn),
                  String(eTranscriptionLanguage.en),
                ].includes(lang || '') && (
                  <SummaryAnimation>
                    <div id="tingwu2-bigmodel-top" style={{ height: 12 }} />
                  </SummaryAnimation>
                )}
              <IntelligenceLoading />
              <BusKeyWord />

              {/* 全文概要 */}
              {/* {DirtyMeetingSummaryCardContent} */}
              {/* 解决position: sticky粘连时候，切换tab抖动问题 */}
              <div id="tingwu2_bigModelTabsBeforeRef" />
              {controller ? (
                <SummaryAnimation>
                  <div
                    style={{
                      marginBottom:
                        isDocBigModelDataHasValue || !quickLookVisible ? 0 : 28,
                    }}
                  >
                    <BigModelTabs />
                  </div>
                </SummaryAnimation>
              ) : null}

              <div style={{ height: 20 }} />
            </div>
            {ToTopView}
          </>
        )}
      </FileWulabContainer>
    </>
  );
};

export default FileWulab;
