import React, { memo } from 'react';
import { Wrapper } from './styled';

export interface SphereCardProps {
  content?: React.ReactNode;
  style?: React.CSSProperties;
  className?: string;
}

export const SphereCard: React.FC<SphereCardProps> = memo((props) => {
  const { content, style, className } = props;
  return (
    <Wrapper className={className} style={style}>
      {content}
    </Wrapper>
  );
});
