import { Markdown } from '@tingwujs/components';
import React from 'react';
import { MultiEllipsisContainer } from './styled';

interface MultiEllipsisProps extends React.HTMLAttributes<HTMLDivElement> {
  text: string;
  lineClamp?: number;
  showRedDot?: boolean;
  showExpend?: boolean;
  expandDefult?: boolean;
  onExpand?: (v: boolean) => void;
}

export const MultiEllipsis = (props: MultiEllipsisProps) => {
  const { text, ...rest } = props;
  return (
    <MultiEllipsisContainer {...rest}>
      <Markdown content={text} className="MultiEllipsis__Markdown" />
    </MultiEllipsisContainer>
  );
};
