import styled from 'styled-components';

export const ContentWrapper = styled.div`
  position: relative;
`;

export const HideDiv = styled.div`
  font-size: 14px;
  line-height: 24px;
  opacity: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  z-index: -1;
  pointer-events: none;
`;

export const InputContentWrapper = styled.div<{ isError: boolean }>`
  border-radius: 8px;
  background: var(--Fill_Background_Light);
  border: 1px solid var(--Text_Primary);
  // box-shadow: 0 0 0 2px #c6c5f2;
  overflow: overlay;
  ${(props) =>
    props.isError &&
    `
    border: 1px solid var(--Danger_Clicked);
    box-shadow: none;
  `}
  padding: 12px;
  display: flex;
  flex-direction: column;
  [contenteditable]:focus {
    outline: none;
    font-weight: normal;
    color: var(--Text_Primary);
  }
  position: relative;
  .m_input {
    min-height: 24px;
    font-size: 14px;
    font-weight: normal;
    line-height: 24px;
    text-align: justify; /* 浏览器可能不支持 */
    letter-spacing: 0px;
    color: var(--Text_Primary);
    position: relative;
    z-index: 2;
    -webkit-user-modify: read-write-plaintext-only;
    white-space: wrap;
  }
  .m_placeholder {
    font-size: 14px;
    font-weight: normal;
    line-height: 22px;
    letter-spacing: 0px;
    color: var(--Text_Disabled);
    position: absolute;
    z-index: 1;
  }
`;

export const ButtonsContainer = styled.div`
  display: flex;
  justify-content: flex-end;
  align-items: center;
  margin-top: 8px;
  height: 20px;
  .m_line {
    height: 15px;
    width: 1px;
    margin-left: 16px;
    background-color: var(--Line_Light);
    border: 0px solid var(--Line_Light);
  }
  .m_confirm {
    color: var(--Text_Primary);
    height: 20px;
    // width: 24px;
    font-weight: 400;
    font-size: 12px;
    letter-spacing: 0;
    line-height: 20px;
    margin-left: 16px;
    cursor: pointer;
    :hover {
      color: var(--Text_Secondary);
    }
  }
  .m_cancel {
    height: 20px;
    // width: 24px;
    font-weight: 400;
    font-size: 12px;
    color: var(--Text_Disabled);
    letter-spacing: 0;
    line-height: 20px;
    margin-left: 33px;
    cursor: pointer;
    :hover {
      color: var(--Text_Disabled);
    }
  }
  .m_loading {
    color: var(--Text_Disabled);
    cursor: not-allowed;
    :hover {
      color: var(--Text_Disabled);
    }
  }
  .m_loading_cancel {
    color: var(--Text_Secondary);
    :hover {
      color: var(--Text_Secondary);
    }
  }
`;
