import { docBigModelHooks } from '../../../../../../documentModel';
import { Exception } from '@tingwujs/design';
import { Container, Content } from './styled';

const CustomPrompt = () => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  if (
    !currentDocBigModelData ||
    !currentDocBigModelData.customPrompt ||
    !currentDocBigModelData.customPrompt.value
  ) {
    return (
      <Container>
        <Exception
          fullScreen
          showBtn={false}
          type="noData"
          title=""
          description={'暂无数据'}
        />
      </Container>
    );
  }
  return (
    <Container>
      <Content>{currentDocBigModelData.customPrompt.value}</Content>
    </Container>
  );
};

export default CustomPrompt;
