import { Tabs } from '..';

let currentTab: Tabs = Tabs.Agenda;

const setInnerTab = (val) => {
  currentTab = val;
};
const getInnerTab = () => currentTab;
const setInnerIsShowFeedbackModal = (val) => {
  currentTab = val;
};

const AppraiseList = () => {
  let _list: string[] = [];
  switch (getInnerTab()) {
    case Tabs.Agenda:
    case Tabs.SpeakerSummary:
      _list = [
        '内容与原文不相关',
        '内容总结不全面',
        '表达不流畅',
        '存在事实性错误',
      ];
      break;
    case Tabs.PPT:
      _list = [
        '提取结果有遗漏',
        '提取结果重复',
        '提取结果存在错误',
        '文字总结不准确',
      ];
      break;
    case Tabs.Highlights:
      _list = [
        '要点回顾不准确',
        '内容与原文无关',
        '要点回顾多了',
        '要点回顾少了',
      ];
      break;
    case Tabs.QNAReview:
      _list = [
        '问答回顾不准确',
        '内容与原文无关',
        '问答回顾多了',
        '问答回顾少了',
      ];
      break;
    case Tabs.ToDoList: {
      _list = [
        '待办事项识别少了',
        '待办事项识别多了',
        '待办提炼不准确',
        '内容与原文无关',
      ];
      break;
    }
    default: {
      break;
    }
  }
  return _list;
};

const AppraiseTitle = () => {
  let title = '';
  switch (getInnerTab()) {
    case Tabs.Agenda:
      title = '你觉得章节速览准确吗？';
      break;
    case Tabs.SpeakerSummary:
      title = '你觉得发言总结准确吗？';
      break;
    case Tabs.PPT:
      title = '你觉得提取PPT准确吗？';
      break;
    case Tabs.Highlights:
      title = '你觉得要点回顾准确吗？';
      break;
    case Tabs.QNAReview:
      title = '你觉得问答回顾准确吗？';
      break;
    case Tabs.ToDoList:
      title = '你觉得待办事项准确吗？';
      break;
    default: {
      break;
    }
  }
  return title;
};

export {
  AppraiseList,
  AppraiseTitle,
  setInnerTab,
  setInnerIsShowFeedbackModal,
};
