import React, { memo, RefObject, useEffect, useRef, useState } from 'react';
import styled from 'styled-components';
import { AgendaSummaryBean } from '../agendaBean';

export const TipsAgendaContainerBg = styled.div`
  background-position: top left;
  background-size: cover;
  background-repeat: no-repeat;
  position: relative;
  width: 459px;
  border-radius: 8px;
  background-color: var(--Fill_Background_Light);
  border: 1px solid var(--Line_Secondary);
  box-shadow: 0px 4px 6px 0px rgba(0, 0, 0, 0.08);
  .agende-tips-dot {
    position: absolute;
    bottom: -7px;
  }
`;

export const TipsAgendaContainer = styled.div<{ clamp?: number }>`
  width: 441px;
  padding: 12px 16px;
  display: flex;
  .tipsAgenda-left {
    margin-right: 7px;
    padding-top: 6px;
    position: relative;
    .agendaReTimeItem-left-dashed {
      position: absolute;
      right: 3px;
      top: 25px;
      bottom: 0;
      overflow: hidden;
    }
    .tipsAgenda-left-dot {
      height: 7px;
      width: 7px;
      /* background-color: #615ced; */
      border-radius: 12px;
      /* box-shadow: rgb(96 92 229 / 20%) 0px 0px 0px 3px; */
    }
  }
  .tipsAgenda-right {
    width: 100%;
    padding-bottom: 10px;
    overflow: hidden;
    .tipsAgenda-right-top {
      display: flex;
      justify-content: space-between;
      min-height: 20px;
      align-items: center;
      margin-bottom: 4px;
      .tipsAgenda-right-top-title {
        font-size: 12px;
        color: var(--Text_Brand_Primary);
        -webkit-font-smoothing: antialiased;
        font-weight: 600;
      }
      .tipsAgenda-right-top-time {
        font-weight: 400;
        font-size: 12px;
        color: var(--Text_Caption);
        margin-right: 6px;
      }
    }
    .tipsAgenda-right-des {
      font-weight: 400;
      font-size: 12px;
      color: var(--Text_Secondary);
      letter-spacing: 0;
      text-align: justify;
      line-height: 20px;
      width: 100%;
      opacity: ${({ clamp }) => (clamp !== undefined ? 1 : 0)};
      ${({ clamp }) => {
        if (clamp) {
          return ` text-overflow: -o-ellipsis-lastline;
      overflow: hidden; 
      text-overflow: ellipsis; 
      display: -webkit-box;
      -webkit-line-clamp: ${clamp}; 
      line-clamp: ${clamp};
      -webkit-box-orient: vertical; `;
        }
        return '';
      }}
    }
  }

  .tips-arrow {
    left: 50%;
    transform: translateX(-50%) translateY(100%) rotate(180deg);
    position: absolute;
    bottom: 0px;
    z-index: 1;
    display: block;
    pointer-events: none;
    width: 16px;
    height: 16px;
    overflow: hidden;

    ::before {
      position: absolute;
      bottom: 0;
      left: 0;
      width: 16px;
      height: 8px;
      background: var(--Fill_Background_Light);
      clip-path: polygon(
        1.6568542494923806px 100%,
        50% 1.6568542494923806px,
        14.34314575050762px 100%,
        1.6568542494923806px 100%
      );
      clip-path: path(
        'M 0 8 A 4 4 0 0 0 2.82842712474619 6.82842712474619 L 6.585786437626905 3.0710678118654755 A 2 2 0 0 1 9.414213562373096 3.0710678118654755 L 13.17157287525381 6.82842712474619 A 4 4 0 0 0 16 8 Z'
      );
      content: '';
    }

    &::after {
      content: '';
      position: absolute;
      width: 8.970562748477143px;
      height: 8.970562748477143px;
      bottom: 0;
      left: 0;
      right: 0;
      margin: auto;
      border-radius: 0 0 2px 0;
      transform: translateY(50%) rotate(-135deg);
      box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.05);
      z-index: 0;
      background: transparent;
    }
  }
`;

const TipsAgenda = memo(
  ({
    isDotVisible,
    info,
    time,
    style,
    maxHeight,
  }: {
    isDotVisible?: boolean;
    info?: AgendaSummaryBean;
    time?: string;
    style?: React.CSSProperties;
    maxHeight?: number;
  }) => {
    return (
      <TipsAgendaContainerBg style={{ ...style }}>
        <TipsAgendaContext
          // isDotVisible={isDotVisible}
          style={{ opacity: 0, ...style }}
          info={info}
          time={time}
          maxHeight={maxHeight}
        />
        {!isDotVisible && (
          <img
            src={
              'https://img.alicdn.com/imgextra/i4/O1CN01xZIcIy1tguYfF0FtC_!!6000000005932-2-tps-260-55.png'
            }
            className="agende-tips-dot"
          />
        )}
        {info && (
          <TipsAgendaContext
            // isDotVisible={isDotVisible}
            style={{ position: 'absolute', top: 0, left: 0, ...style }}
            info={info}
            time={time}
            maxHeight={maxHeight}
          />
        )}
      </TipsAgendaContainerBg>
    );
  },
);

export default TipsAgenda;

export const TipsAgendaContext = ({
  style,
  info,
  time,
  maxHeight,
  arrowLeft,
}: {
  style?: React.CSSProperties;
  // isDotVisible?: boolean;
  info?: AgendaSummaryBean;
  time?: string;
  maxHeight?: number;
  arrowLeft?: number;
}) => {
  const tipsAgendaRightRef: RefObject<HTMLDivElement> = useRef<any>();
  const tipsAgendaRightTopRef: RefObject<HTMLDivElement> = useRef<any>();
  const [desClamp, setClamp] = useState<number | undefined>(
    maxHeight !== undefined ? undefined : 100,
  );

  useEffect(() => {
    if (
      maxHeight !== undefined &&
      tipsAgendaRightRef.current &&
      tipsAgendaRightTopRef.current
    ) {
      const heightValue =
        maxHeight - 24 - tipsAgendaRightTopRef.current.clientHeight - 4;
      setClamp(Math.floor(heightValue / 20));
    }
  }, [
    tipsAgendaRightRef.current,
    tipsAgendaRightTopRef.current,
    maxHeight,
    time,
  ]);
  return (
    <TipsAgendaContainer style={{ ...style }} clamp={desClamp}>
      {info ? (
        <>
          <div className="tipsAgenda-right" ref={tipsAgendaRightRef}>
            <div className="tipsAgenda-right-top" ref={tipsAgendaRightTopRef}>
              <div className="tipsAgenda-right-top-title">
                <span className="tipsAgenda-right-top-time">{time}</span>
                {info?.agendaHeading}
              </div>
            </div>
            <div className="tipsAgenda-right-des">{info?.content}</div>
          </div>
          <div className="tips-arrow" style={{ left: arrowLeft }} />
        </>
      ) : null}
    </TipsAgendaContainer>
  );
};
