import { TYIcon } from '@tingwujs/design';
import React, { useCallback } from 'react';
import { CustomSlider } from './styled';

interface iVolumeControlProps {
  volume: number;
  muted: boolean;
  onMuted: (muted: boolean) => void;
  onVolumeChange: (volume: number) => void;
}

// 音量控制器
const VolumeControl: React.FC<iVolumeControlProps> = (props) => {
  const { muted, volume, onMuted, onVolumeChange } = props;

  const onSlideChange = useCallback(
    (value: number) => {
      const percent = value / 100;
      if (percent > 0 && muted) {
        onMuted(false);
      }
      onVolumeChange(percent);
    },
    [onMuted, onVolumeChange, muted],
  );

  return (
    <div className="volume_bar">
      {muted || volume === 0 ? (
        <TYIcon type="spark-mute-line" onClick={() => onMuted(false)} />
      ) : (
        <TYIcon type="spark-volume-line" onClick={() => onMuted(true)} />
      )}
      <CustomSlider
        min={0}
        max={100}
        className="customSlider"
        value={muted ? 0 : volume * 100}
        onChange={onSlideChange}
        tipFormatter={null}
      />
      <span className="volume">
        {muted ? 0 : parseInt(`${volume * 100}`, 10)}%
      </span>
    </div>
  );
};

const memoVolumeControl = React.memo(VolumeControl);
export { memoVolumeControl as VolumeControl };
