import { Switch } from 'antd';
import React from 'react';

interface iSwitchControlProps {
  title: string;
  checked: boolean;
  onChange: (checked: boolean) => void;
}

// 切换控制
const SwitchControl: React.FC<iSwitchControlProps> = (props) => {
  const { title, checked, onChange } = props;

  return (
    <div className="skip_blank">
      <div>{title}</div>
      <Switch size="small" checked={checked} onChange={onChange} />
    </div>
  );
};

const memoSwitchControl = React.memo(SwitchControl);
export { memoSwitchControl as SwitchControl };
